/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.util.Arrays;

public abstract class AbstractTlsSecret
implements TlsSecret {
    protected static final int MD5_SIZE = 16;
    protected static final byte[][] SSL3_CONST = AbstractTlsSecret.generateSSL3Constants();
    protected byte[] data;

    private static byte[][] generateSSL3Constants() {
        int n = 10;
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] byArray = new byte[i + 1];
            Arrays.fill((byte[])byArray, (byte)((byte)(65 + i)));
            byArrayArray[i] = byArray;
        }
        return byArrayArray;
    }

    protected AbstractTlsSecret(byte[] byArray) {
        this.data = byArray;
    }

    public synchronized byte[] encrypt(TlsCertificate tlsCertificate) throws IOException {
        this.checkAlive();
        return this.getCrypto().createEncryptor(tlsCertificate).encrypt(this.data, 0, this.data.length);
    }

    public synchronized void destroy() {
        if (this.data != null) {
            Arrays.fill((byte[])this.data, (byte)0);
            this.data = null;
        }
    }

    public synchronized byte[] extract() {
        this.checkAlive();
        byte[] byArray = this.data;
        this.data = null;
        return byArray;
    }

    public TlsCipher createCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        return this.getCrypto().createCipher(tlsCryptoParameters, n, n2);
    }

    byte[] copyData() {
        return Arrays.clone((byte[])this.data);
    }

    protected void checkAlive() {
        if (this.data == null) {
            throw new IllegalStateException("Secret has already been extracted or destroyed");
        }
    }

    protected abstract AbstractTlsCrypto getCrypto();
}

