/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.TlsCredentialedAgreement;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHConfigVerifier;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsSecret;

public class TlsDHKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected TlsCredentialedAgreement agreementCredentials;
    protected TlsCertificate dhPeerCertificate;
    protected TlsDHConfig dhConfig;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHKeyExchange(int n, Vector vector, TlsDHConfigVerifier tlsDHConfigVerifier) {
        this(n, vector, tlsDHConfigVerifier, null);
    }

    public TlsDHKeyExchange(int n, Vector vector, TlsDHConfig tlsDHConfig) {
        this(n, vector, null, tlsDHConfig);
    }

    private TlsDHKeyExchange(int n, Vector vector, TlsDHConfigVerifier tlsDHConfigVerifier, TlsDHConfig tlsDHConfig) {
        super(TlsDHKeyExchange.checkKeyExchange(n), vector);
        this.dhConfigVerifier = tlsDHConfigVerifier;
        this.dhConfig = tlsDHConfig;
    }

    public void skipServerCredentials() throws IOException {
        if (this.keyExchange != 11) {
            throw new TlsFatalAlert(80);
        }
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (this.keyExchange == 11) {
            throw new TlsFatalAlert(80);
        }
        if (!(tlsCredentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        this.agreementCredentials = (TlsCredentialedAgreement)tlsCredentials;
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        if (this.keyExchange == 11) {
            throw new TlsFatalAlert(10);
        }
        this.checkServerCertSigAlg(certificate);
        this.dhPeerCertificate = this.validatePeerCertificate(0, certificate);
    }

    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 3: 
            case 5: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        if (!this.requiresServerKeyExchange()) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsDHUtils.writeDHConfig(this.dhConfig, byteArrayOutputStream);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.generateEphemeral(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.dhConfigVerifier, inputStream);
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.processEphemeral(byArray);
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        if (this.keyExchange == 11) {
            throw new TlsFatalAlert(40);
        }
        short[] sArray = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < sArray.length; ++i) {
            switch (sArray[i]) {
                case 3: 
                case 4: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (this.keyExchange == 11) {
            throw new TlsFatalAlert(80);
        }
        if (!(tlsCredentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        this.agreementCredentials = (TlsCredentialedAgreement)tlsCredentials;
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        if (this.agreementCredentials == null) {
            this.generateEphemeral(outputStream);
        }
    }

    public void processClientCertificate(Certificate certificate) throws IOException {
        if (this.keyExchange == 11) {
            throw new TlsFatalAlert(10);
        }
        if (this.agreementCredentials != null) {
            this.dhPeerCertificate = this.validatePeerCertificate(1, certificate);
        }
    }

    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        if (this.dhPeerCertificate != null) {
            return;
        }
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        this.processEphemeral(byArray);
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        if (this.agreementCredentials != null) {
            return this.agreementCredentials.generateAgreement(this.dhPeerCertificate);
        }
        if (this.agreement != null) {
            return this.agreement.calculateSecret();
        }
        throw new TlsFatalAlert(80);
    }

    protected void generateEphemeral(OutputStream outputStream) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, outputStream);
    }

    protected void processEphemeral(byte[] byArray) throws IOException {
        this.agreement.receivePeerValue(byArray);
    }

    protected TlsCertificate validatePeerCertificate(int n, Certificate certificate) throws IOException {
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        return certificate.getCertificateAt(0).useInRole(n, this.keyExchange);
    }
}

