/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.AbstractTlsClient;
import org.bouncycastle.tls.DefaultTlsDHConfigVerifier;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsDHConfigVerifier;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsPSKIdentity;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.util.Arrays;

public class PSKTlsClient
extends AbstractTlsClient {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52396, 49207, 49205, 52397, 170, 178, 144};
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected TlsPSKIdentity pskIdentity;
    protected int[] supportedCipherSuites;

    public PSKTlsClient(TlsCrypto tlsCrypto, TlsPSKIdentity tlsPSKIdentity) {
        this(tlsCrypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsDHConfigVerifier(), tlsPSKIdentity);
    }

    public PSKTlsClient(TlsCrypto tlsCrypto, TlsKeyExchangeFactory tlsKeyExchangeFactory, TlsDHConfigVerifier tlsDHConfigVerifier, TlsPSKIdentity tlsPSKIdentity) {
        super(tlsCrypto, tlsKeyExchangeFactory);
        this.dhConfigVerifier = tlsDHConfigVerifier;
        this.pskIdentity = tlsPSKIdentity;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(tlsCrypto, BASE_CIPHER_SUITES);
    }

    public int[] getCipherSuites() {
        return Arrays.clone((int[])this.supportedCipherSuites);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 14: {
                return this.createPSKKeyExchange(n, this.dhConfigVerifier, null);
            }
            case 24: {
                return this.createPSKKeyExchange(n, null, this.createECConfigVerifier());
            }
            case 13: 
            case 15: {
                return this.createPSKKeyExchange(n, null, null);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int n, TlsDHConfigVerifier tlsDHConfigVerifier, TlsECConfigVerifier tlsECConfigVerifier) throws IOException {
        return this.keyExchangeFactory.createPSKKeyExchangeClient(n, this.supportedSignatureAlgorithms, this.pskIdentity, tlsDHConfigVerifier, tlsECConfigVerifier, this.clientECPointFormats, this.serverECPointFormats);
    }
}

