/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.tls.TlsDHConfigVerifier;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.DHStandardGroups;
import org.bouncycastle.tls.crypto.TlsDHConfig;

public class DefaultTlsDHConfigVerifier
implements TlsDHConfigVerifier {
    public static final int DEFAULT_MINIMUM_PRIME_BITS = 1024;
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;
    protected int minimumPrimeBits;

    private static void addDefaultGroup(DHGroup dHGroup) {
        DEFAULT_GROUPS.addElement(TlsDHUtils.selectDHConfig(dHGroup));
    }

    public DefaultTlsDHConfigVerifier() {
        this(1024);
    }

    public DefaultTlsDHConfigVerifier(int n) {
        this(DEFAULT_GROUPS, n);
    }

    public DefaultTlsDHConfigVerifier(Vector vector, int n) {
        this.groups = vector;
        this.minimumPrimeBits = n;
    }

    public boolean accept(TlsDHConfig tlsDHConfig) {
        if (tlsDHConfig.getExplicitPG()[0].bitLength() < this.getMinimumPrimeBits()) {
            return false;
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.areGroupsEqual(tlsDHConfig, (TlsDHConfig)this.groups.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public int getMinimumPrimeBits() {
        return this.minimumPrimeBits;
    }

    protected boolean areGroupsEqual(TlsDHConfig tlsDHConfig, TlsDHConfig tlsDHConfig2) {
        return tlsDHConfig == tlsDHConfig2 || this.areParametersEqual(tlsDHConfig.getExplicitPG(), tlsDHConfig2.getExplicitPG());
    }

    protected boolean areParametersEqual(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        return bigIntegerArray == bigIntegerArray2 || this.areParametersEqual(bigIntegerArray[0], bigIntegerArray2[0]) && this.areParametersEqual(bigIntegerArray[1], bigIntegerArray2[1]);
    }

    protected boolean areParametersEqual(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger == bigInteger2 || bigInteger.equals(bigInteger2);
    }

    static {
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_1536);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_2048);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_3072);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_4096);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_6144);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_8192);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc5996_768);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc5996_1024);
    }
}

