/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.bouncycastle.jsse.provider.ProvSSLParameters;

class SSLParametersUtil {
    private static final Method getAlgorithmConstraints;
    private static final Method setAlgorithmConstraints;
    private static final Method getEndpointIdentificationAlgorithm;
    private static final Method setEndpointIdentificationAlgorithm;
    private static final Method getUseCipherSuitesOrder;
    private static final Method setUseCipherSuitesOrder;

    SSLParametersUtil() {
    }

    static SSLParameters toSSLParameters(final ProvSSLParameters provSSLParameters) {
        final SSLParameters sSLParameters = new SSLParameters();
        sSLParameters.setCipherSuites(provSSLParameters.getCipherSuites());
        sSLParameters.setProtocols(provSSLParameters.getProtocols());
        if (setAlgorithmConstraints != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        setAlgorithmConstraints.invoke((Object)sSLParameters, provSSLParameters.getAlgorithmConstraints());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        if (setEndpointIdentificationAlgorithm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        setEndpointIdentificationAlgorithm.invoke((Object)sSLParameters, provSSLParameters.getEndpointIdentificationAlgorithm());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        if (setUseCipherSuitesOrder != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        setUseCipherSuitesOrder.invoke((Object)sSLParameters, provSSLParameters.getUseCipherSuitesOrder());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        if (provSSLParameters.getNeedClientAuth()) {
            sSLParameters.setNeedClientAuth(true);
        } else if (provSSLParameters.getWantClientAuth()) {
            sSLParameters.setWantClientAuth(true);
        } else {
            sSLParameters.setWantClientAuth(false);
        }
        return sSLParameters;
    }

    static ProvSSLParameters toProvSSLParameters(final SSLParameters sSLParameters) {
        ProvSSLParameters provSSLParameters = new ProvSSLParameters();
        provSSLParameters.setCipherSuites(sSLParameters.getCipherSuites());
        provSSLParameters.setProtocols(sSLParameters.getProtocols());
        if (getAlgorithmConstraints != null) {
            provSSLParameters.setAlgorithmConstraints(AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return getAlgorithmConstraints.invoke((Object)sSLParameters, new Object[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }));
        }
        if (getEndpointIdentificationAlgorithm != null) {
            provSSLParameters.setEndpointIdentificationAlgorithm(AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        return (String)getEndpointIdentificationAlgorithm.invoke((Object)sSLParameters, new Object[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }));
        }
        if (getUseCipherSuitesOrder != null) {
            provSSLParameters.setUseCipherSuitesOrder(AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        return (Boolean)getUseCipherSuitesOrder.invoke((Object)sSLParameters, new Object[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }));
        }
        if (sSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else if (sSLParameters.getWantClientAuth()) {
            provSSLParameters.setWantClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(false);
        }
        return provSSLParameters;
    }

    static {
        final Class clazz = AccessController.doPrivileged(new PrivilegedAction<Class>(){

            @Override
            public Class run() {
                try {
                    return BouncyCastleJsseProvider.class.getClassLoader().loadClass("javax.net.ssl.SSLParameters");
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        if (clazz != null) {
            getAlgorithmConstraints = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        return clazz.getMethod("getAlgorithmConstraints", new Class[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            setAlgorithmConstraints = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        return clazz.getMethod("setAlgorithmConstraints", new Class[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            getEndpointIdentificationAlgorithm = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        return clazz.getMethod("getEndpointIdentificationAlgorithm", new Class[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            setEndpointIdentificationAlgorithm = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        return clazz.getMethod("setEndpointIdentificationAlgorithm", new Class[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            getUseCipherSuitesOrder = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        return clazz.getMethod("getUseCipherSuitesOrder", new Class[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            setUseCipherSuitesOrder = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        return clazz.getMethod("setUseCipherSuitesOrder", new Class[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
        } else {
            getAlgorithmConstraints = null;
            setAlgorithmConstraints = null;
            getEndpointIdentificationAlgorithm = null;
            setEndpointIdentificationAlgorithm = null;
            getUseCipherSuitesOrder = null;
            setUseCipherSuitesOrder = null;
        }
    }
}

