/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedDecryptor;

class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    private static Logger LOG = Logger.getLogger(ProvTlsServer.class.getName());
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected Set<String> keyManagerMissCache = null;
    protected TlsCredentials credentials = null;
    protected boolean handshakeComplete = false;

    ProvTlsServer(ProvTlsManager provTlsManager) {
        super(provTlsManager.getContextData().getCrypto());
        this.manager = provTlsManager;
        this.sslParameters = provTlsManager.getProvSSLParameters();
    }

    protected boolean selectCipherSuite(int n) throws IOException {
        if (!this.selectCredentials(n)) {
            return false;
        }
        return super.selectCipherSuite(n);
    }

    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public TlsCredentials getCredentials() throws IOException {
        return this.credentials;
    }

    public int[] getCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        boolean bl;
        boolean bl2 = bl = this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
        if (!bl) {
            return null;
        }
        short[] sArray = new short[]{1, 2, 64};
        Vector vector = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion)) {
            vector = JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
        }
        Vector<X500Name> vector2 = new Vector<X500Name>();
        X509TrustManager x509TrustManager = this.manager.getContextData().getTrustManager();
        if (x509TrustManager != null) {
            for (X509Certificate x509Certificate : x509TrustManager.getAcceptedIssuers()) {
                vector2.addElement(X500Name.getInstance((Object)x509Certificate.getSubjectX500Principal().getEncoded()));
            }
        }
        return new CertificateRequest(sArray, vector, vector2);
    }

    public int getSelectedCipherSuite() throws IOException {
        this.keyManagerMissCache = new HashSet<String>();
        int n = super.getSelectedCipherSuite();
        LOG.fine("Server selected cipher suite: " + this.manager.getContext().getCipherSuiteString(n));
        this.keyManagerMissCache = null;
        return n;
    }

    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
        Level level;
        Level level2 = s == 1 ? Level.FINE : (level = s2 == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String string2 = JsseUtils.getAlertLogMessage("Server raised", s, s2);
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            LOG.log(level, string2, throwable);
        }
    }

    public void notifyAlertReceived(short s, short s2) {
        Level level;
        super.notifyAlertReceived(s, s2);
        Level level2 = level = s == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String string = JsseUtils.getAlertLogMessage("Server received", s, s2);
            LOG.log(level, string);
        }
    }

    public ProtocolVersion getServerVersion() throws IOException {
        String[] stringArray = this.sslParameters.getProtocols();
        if (stringArray != null && stringArray.length > 0) {
            for (ProtocolVersion protocolVersion = this.clientVersion; protocolVersion != null; protocolVersion = protocolVersion.getPreviousVersion()) {
                String string = this.manager.getContext().getProtocolString(protocolVersion);
                if (string == null || !JsseUtils.contains(stringArray, string)) continue;
                LOG.fine("Server selected protocol version: " + protocolVersion);
                this.serverVersion = protocolVersion;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    public void notifyClientCertificate(Certificate certificate) throws IOException {
        boolean bl;
        assert (this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth());
        boolean bl2 = bl = certificate == null || certificate.isEmpty();
        if (bl) {
            if (this.sslParameters.getNeedClientAuth()) {
                throw new TlsFatalAlert(40);
            }
        } else {
            short s;
            String string;
            X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(certificate);
            if (!this.manager.isClientTrusted(x509CertificateArray, string = JsseUtils.getAuthTypeClient(s = certificate.getCertificateAt(0).getClientCertificateType()))) {
                throw new TlsFatalAlert(42);
            }
        }
    }

    public synchronized void notifyHandshakeComplete() throws IOException {
        this.handshakeComplete = true;
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
        SSLSession sSLSession = provSSLSessionContext.reportSession(this.context.getSession());
        ProvSSLConnection provSSLConnection = new ProvSSLConnection(this.context, sSLSession);
        this.manager.notifyHandshakeComplete(provSSLConnection);
    }

    protected boolean selectCredentials(int n) throws IOException {
        this.credentials = null;
        int n2 = TlsUtils.getKeyExchangeAlgorithm(n);
        switch (n2) {
            case 11: 
            case 20: {
                return true;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            default: {
                return false;
            }
        }
        X509KeyManager x509KeyManager = this.manager.getContextData().getKeyManager();
        if (x509KeyManager == null) {
            return false;
        }
        String string = JsseUtils.getAuthTypeServer(n2);
        if (this.keyManagerMissCache.contains(string)) {
            return false;
        }
        Principal[] principalArray = null;
        Socket socket = null;
        String string2 = x509KeyManager.chooseServerAlias(string, principalArray, socket);
        if (string2 == null) {
            this.keyManagerMissCache.add(string);
            return false;
        }
        TlsCrypto tlsCrypto = this.getCrypto();
        if (!(tlsCrypto instanceof JcaTlsCrypto)) {
            throw new UnsupportedOperationException();
        }
        PrivateKey privateKey = x509KeyManager.getPrivateKey(string2);
        Certificate certificate = JsseUtils.getCertificateMessage(tlsCrypto, x509KeyManager.getCertificateChain(string2));
        if (privateKey == null || certificate.isEmpty()) {
            this.keyManagerMissCache.add(string);
            return false;
        }
        switch (n2) {
            case 7: 
            case 9: 
            case 16: 
            case 18: {
                this.credentials = new JceDefaultTlsCredentialedAgreement((JcaTlsCrypto)tlsCrypto, certificate, privateKey);
                return true;
            }
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                short s = TlsUtils.getSignatureAlgorithm(n2);
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.chooseSignatureAndHashAlgorithm(this.context, this.supportedSignatureAlgorithms, s);
                this.credentials = new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.context), (JcaTlsCrypto)tlsCrypto, privateKey, certificate, signatureAndHashAlgorithm);
                return true;
            }
            case 1: {
                this.credentials = new JceDefaultTlsCredentialedDecryptor((JcaTlsCrypto)tlsCrypto, certificate, privateKey);
                return true;
            }
        }
        return false;
    }
}

