/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSocketDirect;
import org.bouncycastle.jsse.provider.SSLParametersUtil;

class ProvSSLServerSocket
extends SSLServerSocket {
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = false;
    protected boolean useClientMode = false;

    protected ProvSSLServerSocket(ProvSSLContextSpi provSSLContextSpi, ContextData contextData) throws IOException {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    protected ProvSSLServerSocket(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, int n) throws IOException {
        super(n);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    protected ProvSSLServerSocket(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, int n, int n2) throws IOException {
        super(n, n2);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    protected ProvSSLServerSocket(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    public synchronized Socket accept() throws IOException {
        ProvSSLSocketDirect provSSLSocketDirect = new ProvSSLSocketDirect(this.context, this.contextData);
        this.implAccept(provSSLSocketDirect);
        if (ProvSSLParameters.hasSslParameters) {
            ((SSLSocket)provSSLSocketDirect).setSSLParameters(SSLParametersUtil.toSSLParameters(this.sslParameters));
        } else {
            String[] stringArray;
            String[] stringArray2 = this.sslParameters.getCipherSuites();
            if (stringArray2 != null) {
                ((SSLSocket)provSSLSocketDirect).setEnabledCipherSuites(stringArray2);
            }
            if ((stringArray = this.sslParameters.getProtocols()) != null) {
                ((SSLSocket)provSSLSocketDirect).setEnabledProtocols(stringArray);
            }
            if (this.sslParameters.getNeedClientAuth()) {
                ((SSLSocket)provSSLSocketDirect).setNeedClientAuth(true);
            } else if (this.sslParameters.getWantClientAuth()) {
                ((SSLSocket)provSSLSocketDirect).setWantClientAuth(true);
            } else {
                ((SSLSocket)provSSLSocketDirect).setWantClientAuth(false);
            }
        }
        ((SSLSocket)provSSLSocketDirect).setEnableSessionCreation(this.enableSessionCreation);
        ((SSLSocket)provSSLSocketDirect).setUseClientMode(this.useClientMode);
        return provSSLSocketDirect;
    }

    public ServerSocketChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        if (!this.context.isSupportedCipherSuites(stringArray)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(stringArray);
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        if (!this.context.isSupportedProtocols(stringArray)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(stringArray);
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sSLParameters);
    }

    public synchronized void setUseClientMode(boolean bl) {
        this.useClientMode = bl;
    }

    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }
}

