/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLServerSocket;
import org.bouncycastle.jsse.provider.SSLParametersUtil;

class ProvSSLParameters {
    static final boolean hasSslParameters;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private Object algorithmConstraints;
    private String endpointIdentificationAlgorithm;
    private boolean useCipherSuitesOrder;

    ProvSSLParameters() {
    }

    public void setCipherSuites(String[] stringArray) {
        this.cipherSuites = stringArray;
    }

    public void setProtocols(String[] stringArray) {
        this.protocols = stringArray;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public String[] getCipherSuites() {
        return (String[])this.cipherSuites.clone();
    }

    public String[] getProtocols() {
        return (String[])this.protocols.clone();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public Object getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(Object object) {
        this.algorithmConstraints = object;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String string) {
        this.endpointIdentificationAlgorithm = string;
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean bl) {
        this.useCipherSuitesOrder = bl;
    }

    static ProvSSLParameters extractDefaultParameters(ProvSSLContextSpi provSSLContextSpi) {
        String[] stringArray;
        if (hasSslParameters) {
            return SSLParametersUtil.toProvSSLParameters(provSSLContextSpi.engineGetDefaultSSLParameters());
        }
        ProvSSLParameters provSSLParameters = new ProvSSLParameters();
        String[] stringArray2 = provSSLContextSpi.getDefaultCipherSuites();
        if (stringArray2 != null) {
            provSSLParameters.setCipherSuites(stringArray2);
        }
        if ((stringArray = provSSLContextSpi.getDefaultProtocols()) != null) {
            provSSLParameters.setProtocols(stringArray);
        }
        provSSLParameters.setNeedClientAuth(false);
        provSSLParameters.setWantClientAuth(false);
        return provSSLParameters;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = ProvSSLServerSocket.class.getClassLoader().loadClass("javax.net.ssl.SSLParameters");
        }
        catch (Exception exception) {
            clazz = null;
        }
        hasSslParameters = clazz != null;
    }
}

