/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.consul;

import com.google.common.net.HostAndPort;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.orbitz.consul.Consul;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.bitsofinfo.hazelcast.discovery.consul.ConsulBuilder;

public class ConsulClientBuilder
implements ConsulBuilder {
    private static final ILogger logger = Logger.getLogger(ConsulClientBuilder.class);

    @Override
    public Consul buildConsul(String consulHost, Integer consulPort, boolean consulSslEnabled, String consulSslServerCertFilePath, String consulSslServerCertBase64, boolean consulServerHostnameVerify) throws Exception {
        try {
            Consul.Builder consulBuilder = Consul.builder();
            if (consulSslEnabled) {
                consulBuilder.withUrl("https://" + consulHost + ":" + consulPort);
                if (consulSslServerCertFilePath != null && !consulSslServerCertFilePath.trim().isEmpty() || consulSslServerCertBase64 != null && !consulSslServerCertBase64.trim().isEmpty()) {
                    consulBuilder.withSslContext(this.getSSLContext(consulSslServerCertFilePath, consulSslServerCertBase64));
                }
                if (!consulServerHostnameVerify) {
                    consulBuilder.withHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String s, SSLSession sslSession) {
                            return true;
                        }
                    });
                }
            } else {
                consulBuilder.withHostAndPort(HostAndPort.fromParts((String)consulHost, (int)consulPort));
            }
            Consul consul = consulBuilder.build();
            return consul;
        }
        catch (Exception e) {
            logger.severe("Unexpected Error occured while buildConsul() - " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private SSLContext getSSLContext(String consulSslServerCertFilePath, String consulSslServerCertBase64) throws Exception {
        try {
            InputStream is = null;
            is = consulSslServerCertFilePath != null && !consulSslServerCertFilePath.trim().isEmpty() ? new FileInputStream(consulSslServerCertFilePath) : new ByteArrayInputStream(Base64.decodeBase64((String)consulSslServerCertBase64));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate caCert = (X509Certificate)cf.generateCertificate(is);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry("caCert", caCert);
            tmf.init(ks);
            TrustManager[] tm = tmf.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(null, tm, null);
            return sslContext;
        }
        catch (Exception e) {
            logger.severe("Unexpected Error getSSLContext() - " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

