/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.consul;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.orbitz.consul.model.agent.Registration;
import java.util.Map;
import org.bitsofinfo.hazelcast.discovery.consul.HealthCheckBuilder;

public class HttpHealthCheckBuilder
implements HealthCheckBuilder {
    private static final String HTTP_TEMPLATE_MYPORT = "#MYPORT";
    private static final String HTTP_TEMPLATE_MYIP = "#MYIP";
    public static final String CONFIG_PROP_HEALTH_CHECK_HTTP = "healthCheckHttp";
    public static final String CONFIG_PROP_HEALTH_CHECK_HTTP_INTERVAL_SECONDS = "healthCheckHttpIntervalSeconds";
    private static final ILogger logger = Logger.getLogger(HttpHealthCheckBuilder.class);

    @Override
    public Registration.RegCheck buildRegistrationCheck(Map<String, Object> registratorConfig, Address localAddress) {
        Registration.RegCheck regCheck = null;
        try {
            String healthCheckHttp = (String)registratorConfig.get(CONFIG_PROP_HEALTH_CHECK_HTTP);
            if (healthCheckHttp != null && !healthCheckHttp.trim().isEmpty()) {
                healthCheckHttp = healthCheckHttp.replaceAll(HTTP_TEMPLATE_MYIP, localAddress.getInetAddress().getHostAddress()).replaceAll(HTTP_TEMPLATE_MYPORT, String.valueOf(localAddress.getPort()));
                Long healthCheckHttpIntervalSeconds = (long)((Integer)registratorConfig.get(CONFIG_PROP_HEALTH_CHECK_HTTP_INTERVAL_SECONDS));
                regCheck = Registration.RegCheck.http((String)healthCheckHttp, (long)healthCheckHttpIntervalSeconds);
            }
        }
        catch (Exception e) {
            logger.severe("Unexpected error occured trying to build HTTP health check : " + e.getMessage(), (Throwable)e);
        }
        return regCheck;
    }
}

