/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.consul;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.orbitz.consul.AgentClient;
import com.orbitz.consul.Consul;
import com.orbitz.consul.model.agent.ImmutableRegistration;
import com.orbitz.consul.model.agent.Registration;
import java.util.Arrays;
import java.util.Map;
import org.bitsofinfo.hazelcast.discovery.consul.ConsulBuilder;
import org.bitsofinfo.hazelcast.discovery.consul.ConsulClientBuilder;
import org.bitsofinfo.hazelcast.discovery.consul.ConsulRegistrator;
import org.bitsofinfo.hazelcast.discovery.consul.ConsulUtility;
import org.bitsofinfo.hazelcast.discovery.consul.HealthCheckBuilder;
import org.bitsofinfo.hazelcast.discovery.consul.ScriptHealthCheckBuilder;

public abstract class BaseRegistrator
implements ConsulRegistrator {
    public static final String CONFIG_PROP_HEALTH_CHECK_PROVIDER = "healthCheckProvider";
    protected ILogger logger = null;
    protected Address myLocalAddress = null;
    protected String[] tags = null;
    protected String consulServiceName = null;
    protected String consulHost = null;
    protected Integer consulPort = null;
    protected String consulAclToken = null;
    protected Map<String, Object> registratorConfig = null;
    private String myServiceId = null;
    private AgentClient consulAgentClient;

    protected abstract Address determineMyLocalAddress(DiscoveryNode var1, Map<String, Object> var2) throws Exception;

    @Override
    public void init(String consulHost, Integer consulPort, String consulServiceName, String[] consulTags, String consulAclToken, boolean consulSslEnabled, String consulSslServerCertFilePath, String consulSslServerCertBase64, boolean consulServerHostnameVerify, DiscoveryNode localDiscoveryNode, Map<String, Object> registratorConfig, ILogger logger) throws Exception {
        this.logger = logger;
        this.tags = consulTags;
        this.consulHost = consulHost;
        this.consulPort = consulPort;
        this.consulServiceName = consulServiceName;
        this.consulAclToken = consulAclToken;
        this.registratorConfig = registratorConfig;
        try {
            this.myLocalAddress = this.determineMyLocalAddress(localDiscoveryNode, registratorConfig);
            logger.info("Determined local DiscoveryNode address to use: " + this.myLocalAddress);
            ConsulBuilder builder = (ConsulBuilder)ConsulClientBuilder.class.newInstance();
            Consul consul = builder.buildConsul(consulHost, consulPort, consulSslEnabled, consulSslServerCertFilePath, consulSslServerCertBase64, consulServerHostnameVerify);
            this.consulAgentClient = consul.agentClient();
        }
        catch (Exception e) {
            String msg = "Unexpected error in configuring LocalDiscoveryNodeRegistration: " + e.getMessage();
            logger.severe(msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    @Override
    public String getMyServiceId() {
        return this.myServiceId;
    }

    @Override
    public void register() throws Exception {
        try {
            this.myServiceId = this.consulServiceName + "-" + this.myLocalAddress.getInetAddress().getHostAddress() + "-" + this.myLocalAddress.getHost() + "-" + this.myLocalAddress.getPort();
            ImmutableRegistration.Builder builder = ImmutableRegistration.builder().name(this.consulServiceName).id(this.myServiceId).address(this.myLocalAddress.getInetAddress().getHostAddress()).port(this.myLocalAddress.getPort()).tags(Arrays.asList(this.tags));
            String healthCheckProvider = this.getHealthCheckProvider((String)this.registratorConfig.get(CONFIG_PROP_HEALTH_CHECK_PROVIDER));
            HealthCheckBuilder healthBuilder = (HealthCheckBuilder)Class.forName(healthCheckProvider).newInstance();
            Registration.RegCheck regCheck = healthBuilder.buildRegistrationCheck(this.registratorConfig, this.myLocalAddress);
            if (regCheck != null) {
                builder.check(regCheck);
            }
            this.consulAgentClient.register((Registration)builder.build(), ConsulUtility.getAclToken(this.consulAclToken));
            this.logger.info("Registered with Consul[" + this.consulHost + ":" + this.consulPort + "] serviceId:" + this.myServiceId);
        }
        catch (Exception e) {
            String msg = "Unexpected error in register(serviceId:" + this.myServiceId + "): " + e.getMessage();
            this.logger.severe(msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    @Override
    public void deregister() throws Exception {
        try {
            this.consulAgentClient.deregister(this.myServiceId);
        }
        catch (Exception e) {
            String msg = "Unexpected error in deregister(serviceId:" + this.myServiceId + "): " + e.getMessage();
            this.logger.severe(msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    private String getHealthCheckProvider(String checkProvider) {
        return checkProvider == null || checkProvider.trim().isEmpty() ? ScriptHealthCheckBuilder.class.getCanonicalName() : checkProvider;
    }
}

