/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventsourcing;

import java.util.Map;
import java.util.concurrent.Executor;
import org.axonframework.common.DirectExecutor;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.eventsourcing.AggregateSnapshotter;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerDefinition;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.modelling.command.RepositoryProvider;
import org.axonframework.spring.config.annotation.SpringBeanDependencyResolverFactory;
import org.axonframework.spring.config.annotation.SpringBeanParameterResolverFactory;
import org.axonframework.spring.config.annotation.SpringHandlerDefinitionBean;
import org.axonframework.spring.config.annotation.SpringHandlerEnhancerDefinitionBean;
import org.axonframework.spring.eventsourcing.SpringAggregateSnapshotter;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringAggregateSnapshotterFactoryBean
implements FactoryBean<SpringAggregateSnapshotter>,
ApplicationContextAware {
    private Executor executor = DirectExecutor.INSTANCE;
    private PlatformTransactionManager transactionManager;
    private ApplicationContext applicationContext;
    private TransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    private EventStore eventStore;
    private RepositoryProvider repositoryProvider;
    private ParameterResolverFactory parameterResolverFactory;
    private HandlerDefinition handlerDefinition;

    public SpringAggregateSnapshotter getObject() {
        Map candidates;
        if (this.transactionManager == null && (candidates = this.applicationContext.getBeansOfType(PlatformTransactionManager.class)).size() == 1) {
            this.transactionManager = (PlatformTransactionManager)candidates.values().iterator().next();
        }
        if (this.eventStore == null) {
            this.eventStore = (EventStore)this.applicationContext.getBean(EventStore.class);
        }
        if (this.repositoryProvider == null) {
            this.repositoryProvider = arg_0 -> ((Configuration)((Configuration)this.applicationContext.getBean(Configuration.class))).repository(arg_0);
        }
        if (this.parameterResolverFactory == null) {
            this.parameterResolverFactory = MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{ClasspathParameterResolverFactory.forClass(this.getObjectType()), new SpringBeanDependencyResolverFactory(this.applicationContext), new SpringBeanParameterResolverFactory(this.applicationContext)});
        }
        if (this.handlerDefinition == null) {
            HandlerDefinition definitions = new SpringHandlerDefinitionBean(this.applicationContext).getObject();
            HandlerEnhancerDefinition enhancers = new SpringHandlerEnhancerDefinitionBean(this.applicationContext).getObject();
            this.handlerDefinition = MultiHandlerDefinition.ordered((HandlerEnhancerDefinition)enhancers, (HandlerDefinition[])new HandlerDefinition[]{definitions});
        }
        Object txManager = this.transactionManager == null ? NoTransactionManager.INSTANCE : new SpringTransactionManager(this.transactionManager, this.transactionDefinition);
        SpringAggregateSnapshotter snapshotter = SpringAggregateSnapshotter.builder().eventStore(this.eventStore).executor(this.executor).transactionManager((TransactionManager)txManager).repositoryProvider(this.repositoryProvider).parameterResolverFactory(this.parameterResolverFactory).handlerDefinition(this.handlerDefinition).build();
        snapshotter.setApplicationContext(this.applicationContext);
        return snapshotter;
    }

    public Class<?> getObjectType() {
        return AggregateSnapshotter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }

    public void setEventStore(EventStore eventStore) {
        this.eventStore = eventStore;
    }

    public void setRepositoryProvider(RepositoryProvider repositoryProvider) {
        this.repositoryProvider = repositoryProvider;
    }

    public void setHandlerDefinition(HandlerDefinition handlerDefinition) {
        this.handlerDefinition = handlerDefinition;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

