/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.channel.group.ChannelGroup;
import java.util.HashSet;
import java.util.Set;
import org.atmosphere.nettosphere.BridgeRuntime;
import org.atmosphere.nettosphere.HttpStaticFileServerHandler;
import org.atmosphere.websocket.WebSocket;

public class RuntimeEngine {
    private final BridgeRuntime runtime;
    private final ChannelGroup httpChannels;
    private final ChannelGroup websocketChannels;

    public RuntimeEngine(BridgeRuntime runtime) {
        this.runtime = runtime;
        this.httpChannels = runtime.httpChannels();
        this.websocketChannels = runtime.websocketChannels();
    }

    public <U> Channel find(U id) {
        Channel c = null;
        if (BridgeRuntime.NETTY_41_PLUS) {
            c = this.websocketChannels.find((ChannelId)id);
            if (c == null) {
                c = this.httpChannels.find((ChannelId)id);
            }
        } else {
            throw new UnsupportedOperationException("You need to use Netty 4.1+ to use this feature");
        }
        return c;
    }

    public <U> WebSocket findWebSocket(U id) {
        if (BridgeRuntime.NETTY_41_PLUS) {
            Object o;
            Channel c = this.websocketChannels.find((ChannelId)id);
            if (c != null && (o = c.attr(HttpStaticFileServerHandler.ATTACHMENT).get()) != null && WebSocket.class.isAssignableFrom(o.getClass())) {
                return (WebSocket)WebSocket.class.cast(o);
            }
        } else {
            throw new UnsupportedOperationException("You need to use Netty 4.1+ to use this feature");
        }
        return null;
    }

    public Set<WebSocket> findAllWebSockets() {
        HashSet<WebSocket> s = new HashSet<WebSocket>();
        for (Channel c : this.websocketChannels) {
            Object o;
            if (c == null || (o = c.attr(HttpStaticFileServerHandler.ATTACHMENT).get()) == null || !WebSocket.class.isAssignableFrom(o.getClass())) continue;
            s.add((WebSocket)WebSocket.class.cast(o));
        }
        return s;
    }

    public ChannelGroup httpChannels() {
        return this.runtime.httpChannels();
    }

    public ChannelGroup websocketChannels() {
        return this.runtime.websocketChannels();
    }
}

