/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import javax.net.ssl.SSLEngine;
import org.atmosphere.nettosphere.BridgeRuntime;
import org.atmosphere.nettosphere.Config;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

class NettyPipelineFactory
implements ChannelPipelineFactory {
    private final transient BridgeRuntime bridgeRuntime;
    private final transient Config config;

    public NettyPipelineFactory(BridgeRuntime bridgeRuntime) {
        this.bridgeRuntime = bridgeRuntime;
        this.config = bridgeRuntime.config();
    }

    public ChannelPipeline getPipeline() {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this.config.sslContext() != null) {
            SSLEngine e = this.config.sslContext().createSSLEngine();
            this.config.sslContextListener().onPostCreate(e);
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(e));
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        if (this.config.aggregateRequestBodyInMemory()) {
            pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(this.config.maxChunkContentLength()));
        }
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        if (this.config.supportChunking()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        for (ChannelUpstreamHandler h : this.config.channelUpstreamHandlers()) {
            pipeline.addLast(h.getClass().getName(), (ChannelHandler)h);
        }
        pipeline.addLast(BridgeRuntime.class.getName(), (ChannelHandler)this.bridgeRuntime);
        return pipeline;
    }
}

