/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelAsyncIOWriter
extends AtmosphereInterceptorWriter {
    private static final Logger logger = LoggerFactory.getLogger(ChannelAsyncIOWriter.class);
    private final Channel channel;
    private final AtomicInteger pendingWrite = new AtomicInteger();
    private final AtomicBoolean asyncClose = new AtomicBoolean(false);
    private final ML listener = new ML();
    private boolean resumeOnBroadcast = false;
    private boolean byteWritten = false;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private boolean headerWritten = false;
    private static final String END = Integer.toHexString(0);
    private static final byte[] CHUNK_DELIMITER = "\r\n".getBytes();
    private static final byte[] ENDCHUNK = (END + "\r\n\r\n").getBytes();
    private long lastWrite = 0L;

    public ChannelAsyncIOWriter(Channel channel) {
        this.channel = channel;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public boolean byteWritten() {
        return this.byteWritten;
    }

    public void resumeOnBroadcast(boolean resumeOnBroadcast) {
        this.resumeOnBroadcast = resumeOnBroadcast;
    }

    public AsyncIOWriter writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
        if (!this.channel.isOpen()) {
            return this;
        }
        try {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)errorCode));
            this.channel.write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }
        catch (Throwable ex) {
            logger.debug("", ex);
        }
        return this;
    }

    public AsyncIOWriter write(AtmosphereResponse r, String data) throws IOException {
        byte[] b = data.getBytes("ISO-8859-1");
        this.write(r, b);
        return this;
    }

    public AsyncIOWriter write(AtmosphereResponse r, byte[] data) throws IOException {
        this.write(r, data, 0, data.length);
        return this;
    }

    public AsyncIOWriter write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
        if (this.channel.isOpen()) {
            this.pendingWrite.incrementAndGet();
            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
            ChannelBufferOutputStream c = new ChannelBufferOutputStream(buffer);
            if (this.headerWritten) {
                c.write(Integer.toHexString(length - offset).getBytes("UTF-8"));
                c.write(CHUNK_DELIMITER);
            }
            c.write(data, offset, length);
            if (this.headerWritten) {
                c.write(CHUNK_DELIMITER);
            }
            this.channel.write((Object)c.buffer()).addListener((ChannelFutureListener)this.listener);
            this.byteWritten = true;
            this.lastWrite = System.currentTimeMillis();
        } else {
            logger.warn("Trying to write on a closed channel {}", (Object)this.channel);
        }
        this.headerWritten = true;
        return this;
    }

    public long lastTick() {
        return this.lastWrite == -1L ? System.currentTimeMillis() : this.lastWrite;
    }

    public void close(AtmosphereResponse r) throws IOException {
        if (!this.byteWritten) {
            r.getOutputStream().flush();
        }
        this.asyncClose.set(true);
        if (this.pendingWrite.get() == 0 && this.channel.isOpen()) {
            this._close();
        }
    }

    void _close() {
        if (!this.isClosed.getAndSet(true)) {
            this.headerWritten = false;
            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
            ChannelBufferOutputStream c = new ChannelBufferOutputStream(buffer);
            try {
                c.write(ENDCHUNK);
                this.channel.write((Object)buffer).addListener(ChannelFutureListener.CLOSE);
            }
            catch (IOException e) {
                logger.trace("Close error", (Throwable)e);
            }
        }
    }

    private final class ML
    implements ChannelFutureListener {
        private ML() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (ChannelAsyncIOWriter.this.channel.isOpen() && (!future.isSuccess() || ChannelAsyncIOWriter.this.pendingWrite.decrementAndGet() == 0 && (ChannelAsyncIOWriter.this.resumeOnBroadcast || ChannelAsyncIOWriter.this.asyncClose.get()))) {
                ChannelAsyncIOWriter.this._close();
            }
        }
    }
}

