/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketResponseFilter;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebSocket.class);
    private final Channel channel;
    private final AtmosphereConfig config;
    private final ChannelBufferFactory factory = new HeapChannelBufferFactory();
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);

    public NettyWebSocket(Channel channel, AtmosphereConfig config) {
        this.channel = channel;
        this.config = config;
    }

    @Override
    public WebSocket redirect(String location) throws IOException {
        logger.error("redirect not supported");
        return this;
    }

    @Override
    public WebSocket writeError(int errorCode, String message) throws IOException {
        if (!this.firstWrite.get()) {
            logger.debug("The WebSocket handshake succeeded but the dispatched URI failed {}:{}. The WebSocket connection is still open and client can continue sending messages.", (Object)message, (Object)errorCode);
        } else {
            logger.debug("{} {}", (Object)errorCode, (Object)message);
        }
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, String data) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        if (this.binaryWrite) {
            byte[] b = this.webSocketResponseFilter.filter(r, data.getBytes(this.resource().getResponse().getCharacterEncoding()));
            if (b != null) {
                this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])b)));
            }
        } else {
            String s = this.webSocketResponseFilter.filter(r, data);
            if (s != null) {
                this.channel.write((Object)new TextWebSocketFrame(s));
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        if (this.binaryWrite) {
            byte[] b = this.webSocketResponseFilter.filter(r, data);
            if (b != null) {
                this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])b)));
            }
        } else {
            byte[] s = this.webSocketResponseFilter.filter(r, data);
            if (s != null) {
                this.channel.write((Object)new TextWebSocketFrame(new String(s, 0, s.length, "UTF-8")));
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(byte[] data, int offset, int length) throws IOException {
        String s;
        this.firstWrite.set(true);
        if (this.channel.isOpen() && (s = this.config.getInitParameter("org.atmosphere.websocket.binaryWrite")) != null && Boolean.parseBoolean(s)) {
            ChannelBuffer c = this.factory.getBuffer(length - offset);
            c.writeBytes(data);
            this.channel.write((Object)new BinaryWebSocketFrame(c));
        }
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        if (this.binaryWrite) {
            if (!WebSocketResponseFilter.NoOpsWebSocketResponseFilter.class.isAssignableFrom(this.webSocketResponseFilter.getClass())) {
                byte[] b = this.webSocketResponseFilter.filter(r, data, offset, length);
                if (b != null) {
                    this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])b, (int)0, (int)b.length)));
                }
            } else {
                this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data, (int)0, (int)data.length)));
            }
        } else {
            String s = this.webSocketResponseFilter.filter(r, new String(data, offset, length, "UTF-8"));
            if (s != null) {
                this.channel.write((Object)new TextWebSocketFrame(s));
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public void close() throws IOException {
        this.channel.close().addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    public WebSocket flush() throws IOException {
        return this;
    }
}

