/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.nettosphere.Handler;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private final Builder b;

    public Config(Builder b) {
        this.b = b;
    }

    public String host() {
        return this.b.host;
    }

    public int port() {
        return this.b.port;
    }

    public Map<String, String> initParams() {
        return this.b.initParams;
    }

    public String path() {
        return this.b.staticResourcePath;
    }

    public String configFile() {
        return this.b.atmosphereDotXmlPath;
    }

    public Class<Broadcaster> broadcaster() {
        return this.b.broadcasterClass;
    }

    public Map<String, AtmosphereHandler> handlersMap() {
        return this.b.handlers;
    }

    public BroadcasterFactory broadcasterFactory() {
        return this.b.broadcasterFactory;
    }

    public Class<? extends BroadcasterCache> broadcasterCache() {
        return this.b.broadcasterCache;
    }

    public Class<? extends WebSocketProtocol> webSocketProtocol() {
        return this.b.webSocketProtocol;
    }

    public static final class Builder {
        private String staticResourcePath = "/";
        private String atmosphereDotXmlPath = "/META-INF/atmosphere.xml";
        private String host = "localhost";
        private int port = 8080;
        private final Map<String, String> initParams = new HashMap<String, String>();
        private final Map<String, AtmosphereHandler> handlers = new HashMap<String, AtmosphereHandler>();
        private Class<? extends WebSocketProtocol> webSocketProtocol;
        private Class<Broadcaster> broadcasterClass;
        private BroadcasterFactory broadcasterFactory;
        private Class<? extends BroadcasterCache> broadcasterCache;

        public Builder resource(String staticResourcePath) {
            this.staticResourcePath = staticResourcePath;
            return this;
        }

        public Builder configFile(String atmosphereDotXmlPath) {
            this.atmosphereDotXmlPath = atmosphereDotXmlPath;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder initParam(String name, String value) {
            this.initParams.put(name, value);
            return this;
        }

        public Builder resource(String path, AtmosphereHandler c) {
            this.handlers.put(path, c);
            return this;
        }

        public Builder resource(String path, Servlet c) {
            this.handlers.put(path, new ReflectorServletProcessor(c));
            return this;
        }

        public Builder handler(Handler handler) {
            return this.handler("/*", handler);
        }

        public Builder handler(String path, final Handler handler) {
            this.handlers.put(path, new AbstractReflectorAtmosphereHandler(){

                @Override
                public void onRequest(AtmosphereResource resource) throws IOException {
                    handler.handle(resource);
                }

                @Override
                public void destroy() {
                }
            });
            return this;
        }

        public Builder resource(Class<?> c) {
            return this.resource(this.staticResourcePath, c);
        }

        public Builder resource(String path, Class<?> c) {
            try {
                if (AtmosphereHandler.class.isAssignableFrom(c)) {
                    this.handlers.put(path, (AtmosphereHandler)AtmosphereHandler.class.cast(c.newInstance()));
                } else if (Servlet.class.isAssignableFrom(c)) {
                    this.handlers.put(path, new ReflectorServletProcessor((Servlet)Servlet.class.cast(c.newInstance())));
                } else {
                    this.staticResourcePath = path;
                    this.initParam("com.sun.jersey.config.property.packages", c.getPackage().getName());
                }
            }
            catch (Exception ex) {
                logger.error("Invalid resource {}", c);
            }
            return this;
        }

        public Builder broadcaster(Class<Broadcaster> broadcasterClass) {
            this.broadcasterClass = broadcasterClass;
            return this;
        }

        public Builder broadcasterFactory(BroadcasterFactory broadcasterFactory) {
            this.broadcasterFactory = broadcasterFactory;
            return this;
        }

        public Builder broadcasterCache(Class<? extends BroadcasterCache> broadcasterCache) {
            this.broadcasterCache = broadcasterCache;
            return this;
        }

        public Builder webSocketProtocol(Class<? extends WebSocketProtocol> webSocketProtocol) {
            this.webSocketProtocol = webSocketProtocol;
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }
}

