/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.websocket.WebSocketAdapter;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
extends WebSocketAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebSocket.class);
    private final Channel channel;
    private final AtmosphereConfig config;
    private final ChannelBufferFactory factory = new HeapChannelBufferFactory();

    public NettyWebSocket(Channel channel, AtmosphereConfig config) {
        this.channel = channel;
        this.config = config;
    }

    @Override
    public void redirect(String location) throws IOException {
        logger.error("redirect not supported");
    }

    @Override
    public void writeError(int errorCode, String message) throws IOException {
        logger.debug("{} {}", (Object)errorCode, (Object)message);
    }

    @Override
    public void write(String data) throws IOException {
        if (!this.channel.isOpen()) {
            return;
        }
        this.channel.write((Object)new TextWebSocketFrame(data));
    }

    @Override
    public void write(byte[] data) throws IOException {
        if (!this.channel.isOpen()) {
            return;
        }
        String s = this.config.getInitParameter("org.atmosphere.websocket.supportBlob");
        if (s != null && Boolean.parseBoolean(s)) {
            ChannelBuffer c = this.factory.getBuffer(data.length);
            c.writeBytes(data);
            this.channel.write((Object)new BinaryWebSocketFrame(c));
        } else {
            this.channel.write((Object)new TextWebSocketFrame(new String(data, 0, data.length, "UTF-8")));
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (!this.channel.isOpen()) {
            return;
        }
        String s = this.config.getInitParameter("org.atmosphere.websocket.supportBlob");
        if (s != null && Boolean.parseBoolean(s)) {
            ChannelBuffer c = this.factory.getBuffer(length - offset);
            c.writeBytes(data);
            this.channel.write((Object)new BinaryWebSocketFrame(c));
        } else {
            this.channel.write((Object)new TextWebSocketFrame(new String(data, offset, length, "UTF-8")));
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close().addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    public void flush() throws IOException {
    }
}

