/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;

public class AtmosphereResourceEventImpl
implements AtmosphereResourceEvent {
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final AtomicBoolean isResumedOnTimeout = new AtomicBoolean(false);
    private Throwable throwable;
    protected Object message;
    protected AtmosphereResourceImpl resource;

    public AtmosphereResourceEventImpl(AtmosphereResourceImpl resource) {
        this.resource = resource;
        this.throwable = null;
    }

    public AtmosphereResourceEventImpl(AtmosphereResourceImpl resource, boolean isCancelled, boolean isResumedOnTimeout) {
        this.isCancelled.set(isCancelled);
        this.isResumedOnTimeout.set(isResumedOnTimeout);
        this.resource = resource;
        this.throwable = null;
    }

    public AtmosphereResourceEventImpl(AtmosphereResourceImpl resource, boolean isCancelled, boolean isResumedOnTimeout, Throwable throwable) {
        this.isCancelled.set(isCancelled);
        this.isResumedOnTimeout.set(isResumedOnTimeout);
        this.resource = resource;
        this.throwable = throwable;
    }

    @Override
    public boolean isResuming() {
        return this.resource.action().type == AtmosphereFramework.Action.TYPE.RESUME;
    }

    @Override
    public boolean isSuspended() {
        return this.resource.action().type == AtmosphereFramework.Action.TYPE.SUSPEND;
    }

    @Override
    public Object getMessage() {
        return this.message;
    }

    @Override
    public AtmosphereResourceEvent setMessage(Object message) {
        this.message = message;
        return this;
    }

    @Override
    public boolean isResumedOnTimeout() {
        return this.isResumedOnTimeout.get();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    protected AtmosphereResourceEvent setCancelled(boolean isCancelled) {
        this.check();
        this.resource.action().type = AtmosphereFramework.Action.TYPE.CANCELLED;
        this.isCancelled.set(isCancelled);
        return this;
    }

    protected AtmosphereResourceEvent setIsResumedOnTimeout(boolean isResumedOnTimeout) {
        this.check();
        this.resource.action().type = AtmosphereFramework.Action.TYPE.TIMEOUT;
        this.isResumedOnTimeout.set(isResumedOnTimeout);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtmosphereResourceEventImpl that = (AtmosphereResourceEventImpl)o;
        if (this.isCancelled != null ? !this.isCancelled.equals(that.isCancelled) : that.isCancelled != null) {
            return false;
        }
        if (this.isResumedOnTimeout != null ? !this.isResumedOnTimeout.equals(that.isResumedOnTimeout) : that.isResumedOnTimeout != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
            return false;
        }
        return !(this.throwable != null ? !this.throwable.equals(that.throwable) : that.throwable != null);
    }

    public int hashCode() {
        int result = this.isCancelled != null ? this.isCancelled.hashCode() : 0;
        result = 31 * result + (this.isResumedOnTimeout != null ? this.isResumedOnTimeout.hashCode() : 0);
        result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
        return result;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    @Override
    public AtmosphereResourceEvent write(byte[] o) throws IOException {
        this.check();
        this.resource.getResponse().getOutputStream().write(o);
        return this;
    }

    @Override
    public Broadcaster broadcaster() {
        return this.resource.getBroadcaster();
    }

    @Override
    public AtmosphereResource getResource() {
        return this.resource;
    }

    @Override
    public AtmosphereResourceEvent write(OutputStream os, Object o) throws IOException {
        this.check();
        this.resource.write(os, o);
        return this;
    }

    private void check() {
        if (this.resource == null) {
            throw new IllegalStateException("Recycled");
        }
    }

    public AtmosphereResourceEvent setThrowable(Throwable t) {
        this.throwable = t;
        return this;
    }

    public AtmosphereResourceEvent destroy() {
        this.resource = null;
        this.message = null;
        return this;
    }

    public String toString() {
        return "AtmosphereResourceEventImpl{isCancelled=" + this.isCancelled + ",\n isResumedOnTimeout=" + this.isResumedOnTimeout + ",\n throwable=" + this.throwable + ",\n message=" + this.message + ",\n\t resource=" + this.resource + '}';
    }
}

