/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.websocket.WsOutbound;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.websocket.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatWebSocket
extends WebSocketAdapter {
    private final WsOutbound outbound;
    private static final Logger logger = LoggerFactory.getLogger(TomcatWebSocket.class);
    private final AtmosphereConfig config;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);

    public TomcatWebSocket(WsOutbound outbound, AtmosphereConfig config) {
        this.outbound = outbound;
        this.config = config;
    }

    @Override
    public void redirect(String location) throws IOException {
        logger.error("WebSocket Redirect not supported");
    }

    @Override
    public void writeError(int errorCode, String message) throws IOException {
        if (!this.firstWrite.get()) {
            logger.debug("The WebSocket handshake succeeded but the dispatched URI failed {}:{}. The WebSocket connection is still open and client can continue sending messages.", (Object)message, (Object)errorCode);
        } else {
            logger.debug("{} {}", (Object)errorCode, (Object)message);
        }
    }

    @Override
    public void write(String data) throws IOException {
        this.firstWrite.set(true);
        logger.trace("WebSocket.write()");
        this.outbound.writeTextMessage(CharBuffer.wrap(data));
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.firstWrite.set(true);
        logger.trace("WebSocket.write()");
        this.outbound.writeTextMessage(CharBuffer.wrap(new String(data)));
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.firstWrite.set(true);
        logger.trace("WebSocket.write()");
        this.outbound.writeTextMessage(CharBuffer.wrap(new String(data, offset, length)));
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public void close() throws IOException {
        logger.trace("WebSocket.close()");
        this.outbound.close(1005, ByteBuffer.wrap(new byte[0]));
    }

    @Override
    public void flush() throws IOException {
    }

    public String toString() {
        return this.outbound.toString();
    }
}

