/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import com.sun.grizzly.websockets.WebSocket;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.container.version.Jetty8WebSocket;
import org.atmosphere.websocket.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrizzlyWebSocket
extends WebSocketAdapter {
    private static final Logger logger = LoggerFactory.getLogger(Jetty8WebSocket.class);
    private final WebSocket webSocket;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);

    public GrizzlyWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    @Override
    public void writeError(int errorCode, String message) throws IOException {
        if (!this.firstWrite.get()) {
            logger.debug("The WebSocket handshake succeeded but the dispatched URI failed {}:{}. The WebSocket connection is still open and client can continue sending messages.", (Object)message, (Object)errorCode);
        } else {
            logger.debug("{} {}", (Object)errorCode, (Object)message);
        }
    }

    @Override
    public void redirect(String location) throws IOException {
        logger.error("redirect not supported");
    }

    @Override
    public void write(String data) throws IOException {
        this.webSocket.send(data);
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.webSocket.send(new String(data));
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.webSocket.send(new String(data, offset, length));
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public void close() throws IOException {
        this.webSocket.close();
    }

    @Override
    public void flush() throws IOException {
    }
}

