/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereMappingException;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.cpr.SessionTimeoutSupport;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsynchronousProcessor
implements AsyncSupport<AtmosphereResourceImpl> {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousProcessor.class);
    protected static final Action timedoutAction = new Action(Action.TYPE.TIMEOUT);
    protected static final Action cancelledAction = new Action(Action.TYPE.CANCELLED);
    protected final AtmosphereConfig config;
    private final EndpointMapper<AtmosphereFramework.AtmosphereHandlerWrapper> mapper;

    public AsynchronousProcessor(AtmosphereConfig config) {
        this.config = config;
        this.mapper = config.framework().endPointMapper();
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
    }

    protected boolean supportSession() {
        return this.config.isSupportSession();
    }

    protected boolean allowSessionTimeoutRemoval() {
        return this.config.isSessionTimeoutRemovalAllowed();
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo();
    }

    public Action suspended(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        return this.action(request, response);
    }

    Action action(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action;
        boolean skipAtmosphereHandler;
        Action a;
        if (!Utils.properProtocol((HttpServletRequest)req) || Utils.webSocketEnabled((HttpServletRequest)req) && !this.supportWebSocket()) {
            res.setStatus(501);
            res.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
            res.flushBuffer();
            return new Action();
        }
        if (this.config.handlers().isEmpty()) {
            logger.error("No AtmosphereHandler found. Make sure you define it inside WEB-INF/atmosphere.xml or annotate using @___Service");
            throw new AtmosphereMappingException("No AtmosphereHandler found. Make sure you define it inside WEB-INF/atmosphere.xml or annotate using @___Service");
        }
        if (res.request() == null) {
            res.request(req);
        }
        if (this.supportSession()) {
            req.getSession(true);
        }
        req.setAttribute(FrameworkConfig.SUPPORT_SESSION, this.supportSession());
        AtmosphereFramework.AtmosphereHandlerWrapper handlerWrapper = this.map(req);
        if (this.config.getBroadcasterFactory() == null) {
            logger.error("Atmosphere is misconfigured and will not work. BroadcasterFactory is null");
            return Action.CANCELLED;
        }
        AtmosphereResourceImpl resource = this.configureWorkflow(null, handlerWrapper, req, res);
        String v = req.getHeader("X-Atmosphere-Binary");
        if (v != null) {
            resource.forceBinaryWrite(Boolean.valueOf(v));
        }
        if ((a = this.invokeInterceptors(this.config.framework().interceptors(), resource)).type() != Action.TYPE.CONTINUE) {
            return a;
        }
        a = this.invokeInterceptors(handlerWrapper.interceptors, resource);
        if (a.type() != Action.TYPE.CONTINUE) {
            return a;
        }
        if (req.getAttribute(FrameworkConfig.NEW_MAPPING) != null) {
            req.removeAttribute(FrameworkConfig.NEW_MAPPING);
            handlerWrapper = this.map(req);
            if (handlerWrapper == null) {
                logger.debug("Remap {}", (Object)resource.uuid());
                throw new AtmosphereMappingException("Invalid state. No AtmosphereHandler maps request for " + req.getRequestURI());
            }
            resource = this.configureWorkflow(resource, handlerWrapper, req, res);
            resource.setBroadcaster(handlerWrapper.broadcaster);
        }
        if (!(skipAtmosphereHandler = (req.getAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name()) != null ? (Boolean)req.getAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name()) : Boolean.FALSE).booleanValue())) {
            try {
                handlerWrapper.atmosphereHandler.onRequest(resource);
            }
            catch (IOException t) {
                resource.onThrowable(t);
                throw t;
            }
        }
        this.postInterceptors(handlerWrapper.interceptors, resource);
        this.postInterceptors(this.config.framework().interceptors(), resource);
        Action action2 = action = skipAtmosphereHandler ? Action.CANCELLED : resource.action();
        if (this.supportSession() && this.allowSessionTimeoutRemoval() && action.type().equals((Object)Action.TYPE.SUSPEND)) {
            SessionTimeoutSupport.setupTimeout(this.config, req.getSession());
        }
        logger.trace("Action for {} was {} with transport " + req.getHeader("X-Atmosphere-Transport"), (Object)(req.resource() != null ? req.resource().uuid() : "null"), (Object)action);
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtmosphereResourceImpl configureWorkflow(AtmosphereResourceImpl resource, AtmosphereFramework.AtmosphereHandlerWrapper handlerWrapper, AtmosphereRequest req, AtmosphereResponse res) {
        this.config.getBroadcasterFactory().add(handlerWrapper.broadcaster, handlerWrapper.broadcaster.getID());
        Broadcaster b = handlerWrapper.broadcaster;
        if (b.isDestroyed()) {
            BroadcasterFactory f;
            BroadcasterFactory broadcasterFactory = f = this.config.getBroadcasterFactory();
            synchronized (broadcasterFactory) {
                f.remove(b, b.getID());
                try {
                    handlerWrapper.broadcaster = f.get(b.getID());
                }
                catch (IllegalStateException ex) {
                    logger.trace("", (Throwable)ex);
                    handlerWrapper.broadcaster = f.lookup(b.getID(), true);
                }
            }
        }
        if (resource == null) {
            resource = (AtmosphereResourceImpl)req.getAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
        }
        if (resource == null) {
            resource = (AtmosphereResourceImpl)AtmosphereResourceFactory.getDefault().create(this.config, handlerWrapper.broadcaster, res, this, handlerWrapper.atmosphereHandler);
        } else {
            try {
                resource.getBroadcaster();
            }
            catch (IllegalStateException ex) {
                resource.setBroadcaster(handlerWrapper.broadcaster);
            }
            resource.atmosphereHandler(handlerWrapper.atmosphereHandler);
        }
        req.setAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE, resource);
        req.setAttribute(FrameworkConfig.ATMOSPHERE_HANDLER_WRAPPER, handlerWrapper);
        req.setAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name(), Boolean.FALSE);
        req.setAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK, new AsynchronousProcessorHook(resource));
        return resource;
    }

    protected void shutdown() {
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
    }

    @Override
    public AsyncSupport complete(AtmosphereResourceImpl r) {
        return this;
    }

    private String path(AtmosphereRequest request) {
        String pathInfo = null;
        try {
            pathInfo = request.getPathInfo();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        String path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        return path;
    }

    private Action invokeInterceptors(List<AtmosphereInterceptor> c, AtmosphereResource r) {
        Action a = Action.CONTINUE;
        for (AtmosphereInterceptor arc : c) {
            boolean skip;
            try {
                a = arc.inspect(r);
            }
            catch (Exception ex) {
                logger.error("Interceptor {} crashed. Processing will continue with other interceptor.", (Object)arc, (Object)ex);
                continue;
            }
            if (a == null) {
                logger.trace("Action was null for {}", (Object)arc);
                a = Action.CANCELLED;
            }
            boolean bl = skip = a.type() == Action.TYPE.SKIP_ATMOSPHEREHANDLER;
            if (skip) {
                logger.trace("AtmosphereInterceptor {} asked to skip the AtmosphereHandler for {}", (Object)arc, (Object)r.uuid());
                r.getRequest().setAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name(), Boolean.TRUE);
            }
            if (a.type() == Action.TYPE.CONTINUE) continue;
            logger.trace("Interceptor {} interrupted the dispatch for {} with " + a, (Object)arc, (Object)r.uuid());
            return a;
        }
        return a;
    }

    private void postInterceptors(List<AtmosphereInterceptor> c, AtmosphereResource r) {
        AtmosphereInterceptor arc = null;
        for (int i = c.size() - 1; i > -1; --i) {
            try {
                arc = c.get(i);
                arc.postInspect(r);
                continue;
            }
            catch (Exception ex) {
                logger.error("Interceptor {} crashed. Processing will continue with other interceptor.", (Object)arc, (Object)ex);
            }
        }
    }

    protected AtmosphereFramework.AtmosphereHandlerWrapper map(AtmosphereRequest req) throws ServletException {
        AtmosphereFramework.AtmosphereHandlerWrapper atmosphereHandlerWrapper = this.mapper.map(req, this.config.handlers());
        if (atmosphereHandlerWrapper == null) {
            logger.debug("No AtmosphereHandler maps request for {} with mapping {}", (Object)req.getRequestURI(), this.config.handlers());
            throw new AtmosphereMappingException("No AtmosphereHandler maps request for " + req.getRequestURI());
        }
        this.config.getBroadcasterFactory().add(atmosphereHandlerWrapper.broadcaster, atmosphereHandlerWrapper.broadcaster.getID());
        return atmosphereHandlerWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action resumed(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        if (r == null) {
            return Action.CANCELLED;
        }
        AtmosphereHandler atmosphereHandler = r.getAtmosphereHandler();
        AtmosphereResourceEventImpl event = r.getAtmosphereResourceEvent();
        if (event != null && event.isResuming() && !event.isCancelled()) {
            AtmosphereResourceImpl atmosphereResourceImpl = r;
            synchronized (atmosphereResourceImpl) {
                atmosphereHandler.onStateChange(event);
            }
        }
        return Action.RESUME;
    }

    public Action timedout(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        logger.trace("Timing out {}", (Object)req);
        if (this.completeLifecycle(req.resource(), false)) {
            this.config.framework().notify(Action.TYPE.TIMEOUT, req, res);
        }
        return timedoutAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean completeLifecycle(AtmosphereResource r, boolean cancelled) {
        if (r != null && !r.isCancelled()) {
            AtmosphereResourceImpl impl;
            logger.trace("Finishing lifecycle for AtmosphereResource {}", (Object)r.uuid());
            AtmosphereResourceImpl atmosphereResourceImpl = impl = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r);
            synchronized (atmosphereResourceImpl) {
                try {
                    if (impl.isCancelled()) {
                        logger.trace("{} is already cancelled", (Object)impl.uuid());
                        boolean bl = false;
                        return bl;
                    }
                    AtmosphereResourceEventImpl e = impl.getAtmosphereResourceEvent();
                    if (!e.isClosedByClient()) {
                        if (cancelled) {
                            e.setCancelled(true);
                        } else {
                            e.setIsResumedOnTimeout(true);
                            Broadcaster b = r.getBroadcaster();
                            if (b instanceof DefaultBroadcaster) {
                                ((DefaultBroadcaster)b).broadcastOnResume(r);
                            }
                        }
                    }
                    this.invokeAtmosphereHandler(impl);
                }
                catch (Throwable ex) {
                    logger.trace("Failed to cancel resource: {}", (Object)impl.uuid(), (Object)ex);
                }
                finally {
                    try {
                        impl.notifyListeners();
                        try {
                            impl.getResponse(false).getOutputStream().close();
                        }
                        catch (Throwable t) {
                            try {
                                impl.getResponse(false).getWriter().close();
                            }
                            catch (Throwable t2) {}
                        }
                        impl.setIsInScope(false);
                        impl.cancel();
                    }
                    catch (Throwable t) {
                        logger.trace("completeLifecycle", t);
                    }
                    finally {
                        impl._destroy();
                    }
                }
                return true;
            }
        }
        logger.trace("AtmosphereResource {} was already cancelled or gc", (Object)(r != null ? r.uuid() : "null"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeAtmosphereHandler(AtmosphereResourceImpl r) throws IOException {
        block10: {
            AtmosphereRequest req = r.getRequest(false);
            try {
                if (r.isInScope()) {
                    String disableOnEvent = r.getAtmosphereConfig().getInitParameter("org.atmosphere.disableOnStateEvent");
                    r.getAtmosphereResourceEvent().setMessage(r.writeOnTimeout());
                    try {
                        AtmosphereHandler atmosphereHandler;
                        if (!(disableOnEvent != null && disableOnEvent.equals(String.valueOf(true)) || (atmosphereHandler = r.getAtmosphereHandler()) == null)) {
                            atmosphereHandler.onStateChange(r.getAtmosphereResourceEvent());
                        }
                        break block10;
                    }
                    catch (IOException ex) {
                        try {
                            r.onThrowable(ex);
                            break block10;
                        }
                        catch (Throwable t) {
                            logger.warn("failed calling onThrowable()", (Throwable)ex);
                        }
                    }
                    break block10;
                }
                logger.trace("AtmosphereResource out of scope {}", (Object)r.uuid());
                return;
            }
            finally {
                Meteor m = (Meteor)req.getAttribute(AtmosphereResourceImpl.METEOR);
                if (m != null) {
                    m.destroy();
                }
            }
        }
    }

    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        logger.trace("Cancelling {}", (Object)req);
        if (this.completeLifecycle(req.resource(), true)) {
            this.config.framework().notify(Action.TYPE.CANCELLED, req, res);
        }
        return cancelledAction;
    }

    @Override
    public boolean supportWebSocket() {
        return false;
    }

    public static final class AsynchronousProcessorHook {
        private final AtmosphereResourceImpl r;

        public AsynchronousProcessorHook(AtmosphereResourceImpl r) {
            this.r = r;
            if (!AsynchronousProcessor.class.isAssignableFrom(r.asyncSupport.getClass())) {
                throw new IllegalStateException("AsyncSupport must extends AsynchronousProcessor");
            }
        }

        public void closed() {
            try {
                if (this.r.isSuspended()) {
                    ((AsynchronousProcessor)this.r.asyncSupport).cancelled(this.r.getRequest(false), this.r.getResponse(false));
                }
            }
            catch (IOException e) {
                logger.debug("", (Throwable)e);
            }
            catch (ServletException e) {
                logger.debug("", (Throwable)e);
            }
        }

        public void timedOut() {
            try {
                ((AsynchronousProcessor)this.r.asyncSupport).timedout(this.r.getRequest(false), this.r.getResponse(false));
            }
            catch (IOException e) {
                logger.debug("", (Throwable)e);
            }
            catch (ServletException e) {
                logger.debug("", (Throwable)e);
            }
        }

        public void resume() {
            ((AsynchronousProcessor)this.r.asyncSupport).action(this.r);
        }
    }
}

