/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.Collections;
import java.util.List;
import org.atmosphere.cache.AbstractBroadcasterCache;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcasterCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderBroadcasterCache
extends AbstractBroadcasterCache {
    private final Logger logger = LoggerFactory.getLogger(HeaderBroadcasterCache.class);

    @Override
    public void addToCache(String broadcasterId, AtmosphereResource r, BroadcasterCache.Message e) {
        long now = System.nanoTime();
        this.put(e, now);
        if (r != null) {
            r.getResponse().setHeader("X-Cache-Date", String.valueOf(now));
        }
    }

    @Override
    public List<Object> retrieveFromCache(String id, AtmosphereResource r) {
        if (r == null) {
            throw new IllegalArgumentException("AtmosphereResource can't be null");
        }
        AtmosphereRequest request = r.getRequest();
        String cacheHeader = request.getHeader("X-Cache-Date");
        r.getResponse().setHeader("X-Cache-Date", String.valueOf(System.nanoTime()));
        if (cacheHeader == null || cacheHeader.isEmpty()) {
            return Collections.emptyList();
        }
        long cacheHeaderTime = 0L;
        if (!cacheHeader.isEmpty()) {
            cacheHeaderTime = Long.valueOf(cacheHeader);
        }
        return this.get(cacheHeaderTime);
    }
}

