/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.VoidExecutorService;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketAdapter;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketProcessor
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketProcessor.class);
    private final AtmosphereFramework framework;
    private final WebSocket webSocket;
    private final WebSocketProtocol webSocketProtocol;
    private final AtomicBoolean loggedMsg = new AtomicBoolean(false);
    private final boolean destroyable;
    private final boolean executeAsync;
    private final ExecutorService asyncExecutor;
    private final ExecutorService voidExecutor;

    public WebSocketProcessor(AtmosphereFramework framework, WebSocket webSocket, WebSocketProtocol webSocketProtocol) {
        this.webSocket = webSocket;
        this.framework = framework;
        this.webSocketProtocol = webSocketProtocol;
        String s = framework.getAtmosphereConfig().getInitParameter(ApplicationConfig.RECYCLE_ATMOSPHERE_REQUEST_RESPONSE);
        this.destroyable = s != null && Boolean.valueOf(s) != false;
        s = framework.getAtmosphereConfig().getInitParameter(ApplicationConfig.WEBSOCKET_PROTOCOL_EXECUTION);
        this.executeAsync = s != null && Boolean.valueOf(s) != false;
        this.asyncExecutor = Executors.newCachedThreadPool();
        this.voidExecutor = VoidExecutorService.VOID;
    }

    public final void dispatch(AtmosphereRequest request) throws IOException {
        if (!this.loggedMsg.getAndSet(true)) {
            logger.debug("Atmosphere detected WebSocket: {}", (Object)this.webSocket.getClass().getName());
        }
        AtmosphereResponse wsr = new AtmosphereResponse(this.webSocket, this.webSocketProtocol, request, this.destroyable);
        request.headers(WebSocketProcessor.configureHeader(request));
        request.setAttribute(WebSocket.WEBSOCKET_SUSPEND, true);
        this.dispatch(request, wsr);
        this.webSocketProtocol.onOpen(this.webSocket);
        if (this.webSocket.resource() != null) {
            if (!this.webSocket.resource().getAtmosphereResourceEvent().isSuspended()) {
                this.webSocketProtocol.onError(this.webSocket, new WebSocketException("No AtmosphereResource has been suspended. The WebSocket will be closed:  " + request.getRequestURI(), wsr));
            } else {
                request.setAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK, new AsynchronousProcessor.AsynchronousProcessorHook((AtmosphereResourceImpl)this.webSocket.resource()));
            }
        }
    }

    public void invokeWebSocketProtocol(String webSocketMessage) {
        List<AtmosphereRequest> list = this.webSocketProtocol.onMessage(this.webSocket, webSocketMessage);
        this.dispatch(list);
    }

    private void dispatch(List<AtmosphereRequest> list) {
        if (list == null) {
            return;
        }
        for (final AtmosphereRequest r : list) {
            if (r == null) continue;
            boolean b = r.dispatchRequestAsynchronously();
            ExecutorService s = this.executeAsync || b ? this.asyncExecutor : this.voidExecutor;
            s.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtmosphereResponse w = new AtmosphereResponse(WebSocketProcessor.this.webSocket, WebSocketProcessor.this.webSocketProtocol, r, WebSocketProcessor.this.destroyable);
                    try {
                        WebSocketProcessor.this.dispatch(r, w);
                    }
                    finally {
                        r.destroy();
                        w.destroy();
                    }
                }
            });
        }
    }

    public void invokeWebSocketProtocol(byte[] data, int offset, int length) {
        List<AtmosphereRequest> list = this.webSocketProtocol.onMessage(this.webSocket, data, offset, length);
        this.dispatch(list);
    }

    protected final void dispatch(AtmosphereRequest request, AtmosphereResponse r) {
        if (request == null) {
            return;
        }
        try {
            this.framework.doCometSupport(request, r);
        }
        catch (Throwable e) {
            logger.warn("Failed invoking AtmosphereFramework.doCometSupport()", e);
            this.webSocketProtocol.onError(this.webSocket, new WebSocketException(e, new AtmosphereResponse.Builder().request(request).status(500).statusMessage("Server Error").build()));
            return;
        }
        AtmosphereResource resource = (AtmosphereResource)request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        if (this.webSocket.resource() == null && WebSocketAdapter.class.isAssignableFrom(this.webSocket.getClass())) {
            ((WebSocketAdapter)WebSocketAdapter.class.cast(this.webSocket)).setAtmosphereResource(resource);
        }
        if (r.getStatus() >= 400) {
            this.webSocketProtocol.onError(this.webSocket, new WebSocketException("Status code higher than 400", r));
        }
    }

    public WebSocket webSocket() {
        return this.webSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int closeCode) {
        logger.debug("WebSocket closed with {}", (Object)closeCode);
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)this.webSocket.resource();
        AtmosphereRequest r = resource.getRequest(false);
        AtmosphereResponse s = resource.getResponse(false);
        try {
            this.webSocketProtocol.onClose(this.webSocket);
            if (resource != null && resource.isInScope()) {
                AsynchronousProcessor.AsynchronousProcessorHook h = (AsynchronousProcessor.AsynchronousProcessorHook)r.getAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK);
                if (h != null) {
                    if (closeCode == 1000) {
                        h.timedOut();
                    } else {
                        h.closed();
                    }
                } else {
                    logger.warn("AsynchronousProcessor.AsynchronousProcessorHook was null");
                }
            }
        }
        finally {
            if (r != null) {
                r.destroy();
            }
            if (s != null) {
                s.destroy();
            }
            if (this.webSocket != null) {
                ((WebSocketAdapter)WebSocketAdapter.class.cast(this.webSocket)).setAtmosphereResource(null);
            }
        }
        this.asyncExecutor.shutdown();
        this.voidExecutor.shutdown();
    }

    public String toString() {
        return "WebSocketProcessor{ webSocket=" + this.webSocket + " }";
    }

    public void notifyListener(WebSocketEventListener.WebSocketEvent event) {
        AtmosphereResource resource = this.webSocket.resource();
        if (resource == null) {
            return;
        }
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource);
        for (AtmosphereResourceEventListener l : r.atmosphereResourceEventListener()) {
            if (!WebSocketEventListener.class.isAssignableFrom(l.getClass())) continue;
            try {
                switch (event.type()) {
                    case CONNECT: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onConnect(event);
                        break;
                    }
                    case DISCONNECT: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
                        break;
                    }
                    case CONTROL: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onControl(event);
                        break;
                    }
                    case MESSAGE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onMessage(event);
                        break;
                    }
                    case HANDSHAKE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onHandshake(event);
                        break;
                    }
                    case CLOSE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onClose(event);
                    }
                }
            }
            catch (Throwable t) {
                logger.debug("Listener error {}", t);
                try {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onThrowable(new AtmosphereResourceEventImpl(r, false, false, t));
                }
                catch (Throwable t2) {
                    logger.warn("Listener error {}", t2);
                }
            }
        }
    }

    public static final Map<String, String> configureHeader(AtmosphereRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration<String> e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            headers.put(s, request.getParameter(s));
        }
        headers.put("X-Atmosphere-Transport", "websocket");
        return headers;
    }

    public static final class WebSocketException
    extends Exception {
        private final AtmosphereResponse r;

        public WebSocketException(String s, AtmosphereResponse r) {
            super(s);
            this.r = r;
        }

        public WebSocketException(Throwable throwable, AtmosphereResponse r) {
            super(throwable);
            this.r = r;
        }

        public AtmosphereResponse response() {
            return this.r;
        }
    }
}

