/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.enterprise.web.connector.grizzly.comet.CometContext;
import com.sun.enterprise.web.connector.grizzly.comet.CometEngine;
import com.sun.enterprise.web.connector.grizzly.comet.CometEvent;
import com.sun.enterprise.web.connector.grizzly.comet.CometHandler;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassFishv2CometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GlassFishv2CometSupport.class);
    private static final String ATMOSPHERE = "/atmosphere";
    private String atmosphereCtx = "";

    public GlassFishv2CometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.atmosphereCtx = sc.getServletContext().getContextPath() + ATMOSPHERE;
        CometEngine cometEngine = CometEngine.getEngine();
        CometContext context = cometEngine.register(this.atmosphereCtx);
        context.setExpirationDelay(-1L);
        logger.debug("Created CometContext for atmosphere context: {}", (Object)this.atmosphereCtx);
    }

    @Override
    public AtmosphereFramework.Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        CometContext ctx = CometEngine.getEngine().getCometContext(this.atmosphereCtx);
        AtmosphereFramework.Action action = this.suspended(req, res);
        if (action.type == AtmosphereFramework.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)res);
            this.suspend(ctx, action, req, res);
        } else if (action.type == AtmosphereFramework.Action.TYPE.RESUME) {
            logger.debug("Resuming response: {}", (Object)res);
            this.resume(req, ctx);
        }
        return action;
    }

    private void suspend(CometContext ctx, AtmosphereFramework.Action action, AtmosphereRequest req, AtmosphereResponse res) {
        VoidCometHandler c = new VoidCometHandler(req, res);
        ctx.setExpirationDelay(action.timeout);
        ctx.addCometHandler((CometHandler)c);
        ctx.addAttribute((Object)"Time", (Object)System.currentTimeMillis());
        req.setAttribute(ATMOSPHERE, c.hashCode());
        if (this.supportSession()) {
            req.getSession().setAttribute(ATMOSPHERE, (Object)c.hashCode());
        }
    }

    private void resume(AtmosphereRequest req, CometContext ctx) {
        if (req.getAttribute(ATMOSPHERE) == null) {
            return;
        }
        CometHandler handler = ctx.getCometHandler(((Integer)req.getAttribute(ATMOSPHERE)).intValue());
        req.removeAttribute(ATMOSPHERE);
        if (handler == null && this.supportSession() && req.getSession(false) != null) {
            handler = ctx.getCometHandler(((Integer)req.getSession(false).getAttribute(ATMOSPHERE)).intValue());
            req.getSession().removeAttribute(ATMOSPHERE);
        }
        if (handler != null && (this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false"))) {
            ctx.resumeCometHandler(handler);
        }
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        super.action(actionEvent);
        if (actionEvent.action().type == AtmosphereFramework.Action.TYPE.RESUME && actionEvent.isInScope()) {
            CometContext ctx = CometEngine.getEngine().getCometContext(this.atmosphereCtx);
            this.resume(actionEvent.getRequest(), ctx);
        }
    }

    @Override
    public AtmosphereFramework.Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        AtmosphereFramework.Action action = super.cancelled(req, res);
        if (req.getAttribute(ApplicationConfig.MAX_INACTIVE) != null && (Long)Long.class.cast(req.getAttribute(ApplicationConfig.MAX_INACTIVE)) == -1L) {
            this.resume(req, CometEngine.getEngine().getCometContext(this.atmosphereCtx));
        }
        return action;
    }

    private class VoidCometHandler
    implements CometHandler {
        private final AtmosphereRequest req;
        private final AtmosphereResponse res;

        private VoidCometHandler(AtmosphereRequest req, AtmosphereResponse res) {
            this.req = req;
            this.res = res;
        }

        public void attach(Object o) {
        }

        public void onEvent(CometEvent ce) throws IOException {
        }

        public void onInitialize(CometEvent ce) throws IOException {
        }

        public void onTerminate(CometEvent ce) throws IOException {
        }

        public synchronized void onInterrupt(CometEvent ce) throws IOException {
            long timeStamp = (Long)ce.getCometContext().getAttribute((Object)"Time");
            try {
                if (ce.getCometContext().getExpirationDelay() > 0L && System.currentTimeMillis() - timeStamp >= ce.getCometContext().getExpirationDelay()) {
                    GlassFishv2CometSupport.this.timedout(this.req, this.res);
                } else {
                    GlassFishv2CometSupport.this.cancelled(this.req, this.res);
                }
            }
            catch (ServletException ex) {
                logger.warn("onInterrupt(): encountered exception", (Throwable)ex);
            }
        }
    }
}

