/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.interceptor.InvokationOrder;

public abstract class ServiceInterceptor
extends AtmosphereInterceptorAdapter {
    protected AtmosphereConfig config;
    protected boolean wildcardMapping = false;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        this.optimizeMapping();
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (!this.wildcardMapping) {
            return Action.CONTINUE;
        }
        this.mapAnnotatedService(r.getRequest(), (AtmosphereFramework.AtmosphereHandlerWrapper)r.getRequest().getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER_WRAPPER));
        return Action.CONTINUE;
    }

    protected void optimizeMapping() {
        for (String w : this.config.handlers().keySet()) {
            if (!w.contains("{") || !w.contains("}")) continue;
            this.wildcardMapping = true;
            break;
        }
    }

    protected void mapAnnotatedService(AtmosphereRequest request, AtmosphereFramework.AtmosphereHandlerWrapper w) {
        Broadcaster b = w.broadcaster;
        String pathInfo = null;
        boolean reMap = false;
        try {
            pathInfo = request.getPathInfo();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        String path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if (b.getID().contains("{")) {
            reMap = true;
            this.config.getBroadcasterFactory().remove(b.getID());
        }
        this.mapAnnotatedService(reMap, path, request, w);
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.AFTER_DEFAULT;
    }

    protected abstract void mapAnnotatedService(boolean var1, String var2, AtmosphereRequest var3, AtmosphereFramework.AtmosphereHandlerWrapper var4);
}

