/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.atmosphere.container.JSR356AsyncSupport;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={})
public class AtmosphereInitializer
implements ServletContainerInitializer {
    private final Logger logger = LoggerFactory.getLogger(AtmosphereInitializer.class);
    private AtmosphereFramework framework;

    public void onStartup(Set<Class<?>> classes, final ServletContext c) throws ServletException {
        this.logger.trace("Initializing AtmosphereFramework");
        this.framework = (AtmosphereFramework)c.getAttribute(AtmosphereFramework.class.getName());
        if (this.framework == null) {
            this.framework = new AtmosphereFramework(false, true);
            DefaultAsyncSupportResolver resolver = new DefaultAsyncSupportResolver(this.framework.getAtmosphereConfig());
            List<Class<? extends AsyncSupport>> l = resolver.detectWebSocketPresent(false, true);
            if (l.size() == 0 && resolver.testClassExists("javax.websocket.Endpoint")) {
                this.framework.setAsyncSupport(new JSR356AsyncSupport(new AtmosphereConfig(this.framework){

                    @Override
                    public ServletContext getServletContext() {
                        return c;
                    }

                    @Override
                    public String getInitParameter(String name) {
                        return c.getInitParameter(name);
                    }

                    @Override
                    public Enumeration<String> getInitParameterNames() {
                        return c.getInitParameterNames();
                    }
                }));
            }
            c.setAttribute(AtmosphereFramework.class.getName(), (Object)this.framework);
        }
    }
}

