/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.jruby.AsciidoctorJRuby;
import org.asciidoctor.jruby.internal.JRubyRuntimeContext;
import org.asciidoctor.maven.extensions.AsciidoctorJExtensionRegistry;
import org.asciidoctor.maven.extensions.ExtensionConfiguration;
import org.asciidoctor.maven.io.AsciidoctorFileScanner;
import org.asciidoctor.maven.log.LogHandler;
import org.asciidoctor.maven.log.LogRecordFormatter;
import org.asciidoctor.maven.log.LogRecordsProcessors;
import org.asciidoctor.maven.log.MemoryLogHandler;
import org.asciidoctor.maven.process.AsciidoctorHelper;
import org.asciidoctor.maven.process.ResourcesProcessor;
import org.asciidoctor.maven.process.SourceDirectoryFinder;
import org.asciidoctor.maven.process.SourceDocumentFinder;
import org.jruby.Ruby;

@Mojo(name="process-asciidoc", threadSafe=true)
public class AsciidoctorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="asciidoctor.sourceDirectory", defaultValue="${basedir}/src/docs/asciidoc")
    protected File sourceDirectory;
    @Parameter(property="asciidoctor.outputDirectory", defaultValue="${project.build.directory}/generated-docs")
    protected File outputDirectory;
    @Parameter(property="asciidoctor.outputFile")
    protected File outputFile;
    @Parameter(property="asciidoctor.preserveDirectories", defaultValue="false")
    protected boolean preserveDirectories = false;
    @Parameter(property="asciidoctor.relativeBaseDir", defaultValue="false")
    protected boolean relativeBaseDir = false;
    @Parameter(property="asciidoctor.projectDirectory", defaultValue="${basedir}")
    protected File projectDirectory;
    @Parameter(property="asciidoctor.rootDir", defaultValue="${basedir}")
    protected File rootDir;
    @Parameter(property="asciidoctor.baseDir")
    protected File baseDir;
    @Parameter(property="asciidoctor.skip")
    protected boolean skip = false;
    @Parameter(property="asciidoctor.gemPath")
    protected String gemPath;
    @Parameter(property="asciidoctor.requires")
    protected List<String> requires = new ArrayList<String>();
    @Parameter
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    @Parameter(property="asciidoctor.attributes")
    protected String attributesChain = "";
    @Parameter(property="asciidoctor.backend", defaultValue="html5")
    protected String backend = "";
    @Parameter(property="asciidoctor.doctype")
    protected String doctype;
    @Parameter(property="asciidoctor.eruby")
    protected String eruby = "";
    @Parameter(property="asciidoctor.headerFooter")
    protected boolean headerFooter = true;
    @Parameter(property="asciidoctor.templateDirs")
    protected List<File> templateDirs = new ArrayList<File>();
    @Parameter(property="asciidoctor.templateEngine")
    protected String templateEngine;
    @Parameter(property="asciidoctor.templateCache")
    protected boolean templateCache = true;
    @Parameter(property="asciidoctor.sourceDocumentName")
    protected String sourceDocumentName;
    @Parameter(property="asciidoctor.sourceDocumentExtensions")
    protected List<String> sourceDocumentExtensions = new ArrayList<String>();
    @Parameter(property="asciidoctor.sourcemap")
    protected boolean sourcemap = false;
    @Parameter(property="asciidoctor.catalogAssets")
    protected boolean catalogAssets = false;
    @Parameter
    protected List<ExtensionConfiguration> extensions = new ArrayList<ExtensionConfiguration>();
    @Parameter(property="asciidoctor.embedAssets")
    protected boolean embedAssets = false;
    @Parameter
    protected List<Resource> resources;
    @Parameter(property="asciidoctor.verbose")
    protected boolean enableVerbose = false;
    @Parameter
    private LogHandler logHandler = new LogHandler();
    @Inject
    protected MavenProject project;
    @Inject
    protected MavenSession session;
    @Inject
    protected MavenResourcesFiltering outputResourcesFiltering;
    protected final ResourcesProcessor defaultResourcesProcessor = (sourcesRootDirectory, outputRootDirectory, encoding, configuration) -> {
        List<Resource> finalResources = this.prepareResources(sourcesRootDirectory, configuration);
        this.copyResources(finalResources, encoding, outputRootDirectory, this.outputResourcesFiltering, this.project, this.session);
    };

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.processAllSources(this.defaultResourcesProcessor);
    }

    public void processAllSources(ResourcesProcessor resourcesProcessor) throws MojoExecutionException {
        this.processSources(null, resourcesProcessor);
    }

    public void processSources(List<File> sourceFiles, ResourcesProcessor resourcesProcessor) throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"AsciiDoc processing is skipped.");
            return;
        }
        if (this.sourceDirectory == null) {
            throw new MojoExecutionException("Required parameter 'asciidoctor.sourceDirectory' not set.");
        }
        Optional<File> sourceDirectoryCandidate = this.findSourceDirectory(this.sourceDirectory, this.project.getBasedir());
        if (!sourceDirectoryCandidate.isPresent()) {
            this.getLog().info((CharSequence)"No sourceDirectory found. Skipping processing");
            return;
        }
        if (sourceFiles == null) {
            sourceFiles = this.findSourceFiles(sourceDirectoryCandidate.get());
        }
        if (sourceFiles.isEmpty()) {
            this.getLog().info((CharSequence)"No sources found. Skipping processing");
            return;
        }
        if (!this.ensureOutputExists()) {
            this.getLog().error((CharSequence)("Can't create " + this.outputDirectory.getPath()));
            return;
        }
        if (this.resources != null) {
            for (Resource resource : this.resources) {
                if (resource.getDirectory() != null && !resource.getDirectory().isEmpty()) continue;
                throw new MojoExecutionException("Found empty resource directory");
            }
        }
        Asciidoctor asciidoctor = this.getAsciidoctorInstance(this.gemPath);
        if (this.enableVerbose) {
            asciidoctor.requireLibrary(new String[]{"enable_verbose.rb"});
        }
        asciidoctor.requireLibraries(this.requires);
        AsciidoctorJExtensionRegistry extensionRegistry = new AsciidoctorJExtensionRegistry(asciidoctor);
        for (ExtensionConfiguration extension : this.extensions) {
            try {
                extensionRegistry.register(extension.getClassName(), extension.getBlockName());
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        AttributesBuilder attributesBuilder = this.createAttributesBuilder(this, this.project);
        OptionsBuilder optionsBuilder = this.createOptionsBuilder(this, attributesBuilder);
        File sourceDir = sourceDirectoryCandidate.get();
        resourcesProcessor.process(sourceDir, this.outputDirectory, this.encoding, this);
        Boolean outputToConsole = this.logHandler.getOutputToConsole() == null ? Boolean.TRUE : this.logHandler.getOutputToConsole();
        MemoryLogHandler memoryLogHandler = new MemoryLogHandler(outputToConsole, sourceDir, logRecord -> this.getLog().info((CharSequence)LogRecordFormatter.format(logRecord, sourceDir)));
        asciidoctor.registerLogHandler((org.asciidoctor.log.LogHandler)memoryLogHandler);
        Logger.getLogger("asciidoctor").setUseParentHandlers(false);
        HashSet<File> uniquePaths = new HashSet<File>();
        for (File source : sourceFiles) {
            File destinationPath = this.setDestinationPaths(source, optionsBuilder, sourceDir, this);
            if (!uniquePaths.add(destinationPath)) {
                this.getLog().warn((CharSequence)("Duplicated destination found: overwriting file: " + destinationPath.getAbsolutePath()));
            }
            this.convertFile(asciidoctor, optionsBuilder.asMap(), source);
            try {
                new LogRecordsProcessors(this.logHandler, sourceDir, errorMessage -> this.getLog().error((CharSequence)errorMessage)).processLogRecords(memoryLogHandler);
            }
            catch (Exception exception) {
                throw new MojoExecutionException(exception.getMessage());
            }
        }
    }

    public Optional<File> findSourceDirectory(File initialSourceDirectory, File baseDir) {
        Optional<File> sourceDirCandidate = new SourceDirectoryFinder(initialSourceDirectory, baseDir, candidate -> {
            String candidateName = candidate.toString();
            if (this.isRelativePath(candidateName)) {
                candidateName = candidateName.substring(2);
            }
            this.getLog().info((CharSequence)("sourceDirectory " + candidateName + " does not exist"));
        }).find();
        return sourceDirCandidate;
    }

    private boolean isRelativePath(String candidateName) {
        return candidateName.startsWith("./") || candidateName.startsWith(".\\");
    }

    private List<Resource> prepareResources(File sourceDirectory, AsciidoctorMojo configuration) {
        ArrayList<Resource> resources;
        ArrayList<Resource> arrayList = resources = configuration.getResources() != null ? configuration.getResources() : new ArrayList<Resource>();
        if (resources.isEmpty()) {
            Resource resource = new Resource();
            resource.setDirectory(sourceDirectory.getAbsolutePath());
            if (!StringUtils.isBlank((CharSequence)configuration.getSourceDocumentName())) {
                resource.getExcludes().add(configuration.getSourceDocumentName());
            }
            resources.add(resource);
        }
        for (Resource resource : resources) {
            ArrayList<String> excludes = new ArrayList<String>();
            for (String value : AsciidoctorFileScanner.INTERNAL_FOLDERS_AND_FILES_PATTERNS) {
                excludes.add(value);
            }
            for (String value : AsciidoctorFileScanner.IGNORED_FILE_NAMES) {
                excludes.add("**/" + value);
            }
            for (String value : AsciidoctorFileScanner.DEFAULT_ASCIIDOC_EXTENSIONS) {
                excludes.add(value);
            }
            for (String docExtension : configuration.getSourceDocumentExtensions()) {
                resource.getExcludes().add("**/*." + docExtension);
            }
            excludes.removeAll(resource.getIncludes());
            resource.getExcludes().addAll(excludes);
        }
        return resources;
    }

    private void copyResources(List<Resource> resources, String encoding, File outputDirectory, MavenResourcesFiltering mavenResourcesFiltering, MavenProject mavenProject, MavenSession mavenSession) throws MojoExecutionException {
        try {
            MavenResourcesExecution resourcesExecution = new MavenResourcesExecution(resources, outputDirectory, mavenProject, encoding, Collections.emptyList(), Collections.emptyList(), mavenSession);
            resourcesExecution.setIncludeEmptyDirs(true);
            resourcesExecution.setAddDefaultExcludes(true);
            mavenResourcesFiltering.filterResources(resourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Could not copy resources", (Exception)((Object)e));
        }
    }

    public File setDestinationPaths(File sourceFile, OptionsBuilder optionsBuilder, File sourceDirectory, AsciidoctorMojo configuration) throws MojoExecutionException {
        try {
            if (configuration.getBaseDir() != null) {
                optionsBuilder.baseDir(configuration.getBaseDir());
            } else if (configuration.isRelativeBaseDir()) {
                optionsBuilder.baseDir(sourceFile.getParentFile());
            } else {
                optionsBuilder.baseDir(sourceDirectory);
            }
            File outputDir = configuration.getOutputDirectory();
            if (configuration.isPreserveDirectories()) {
                String candidatePath = sourceFile.getParentFile().getCanonicalPath().substring(sourceDirectory.getCanonicalPath().length());
                File relativePath = new File(outputDir.getCanonicalPath() + candidatePath);
                optionsBuilder.toDir(relativePath).destinationDir(relativePath);
            } else {
                optionsBuilder.toDir(outputDir).destinationDir(outputDir);
            }
            File outputFile = configuration.getOutputFile();
            String destinationDir = (String)optionsBuilder.asMap().get("destination_dir");
            if (outputFile != null) {
                optionsBuilder.toFile(outputFile);
                return outputFile.isAbsolute() ? outputFile : new File(destinationDir, outputFile.getPath());
            }
            return new File(destinationDir, sourceFile.getName());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to locate output directory", (Exception)e);
        }
    }

    protected Asciidoctor getAsciidoctorInstance(String gemPath) throws MojoExecutionException {
        String gemHomeExpected;
        Ruby rubyInstance;
        AsciidoctorJRuby asciidoctor;
        block8: {
            asciidoctor = null;
            if (gemPath == null) {
                asciidoctor = AsciidoctorJRuby.Factory.create();
            } else {
                String normalizedGemPath = File.separatorChar == '\\' ? gemPath.replaceAll("\\\\", "/") : gemPath;
                asciidoctor = AsciidoctorJRuby.Factory.create((String)normalizedGemPath);
            }
            rubyInstance = null;
            try {
                rubyInstance = (Ruby)JRubyRuntimeContext.class.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                if (rubyInstance != null) break block8;
                try {
                    rubyInstance = (Ruby)JRubyRuntimeContext.class.getMethod("get", Asciidoctor.class).invoke(null, asciidoctor);
                }
                catch (Exception e1) {
                    throw new MojoExecutionException("Failed to invoke get(AsciiDoctor) for JRubyRuntimeContext", e1);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to invoke get for JRubyRuntimeContext", e);
            }
        }
        String gemHome = rubyInstance.evalScriptlet("ENV['GEM_HOME']").toString();
        String string = gemHomeExpected = gemPath == null || "".equals(gemPath) ? "" : gemPath.split(File.pathSeparator)[0];
        if (!"".equals(gemHome) && !gemHomeExpected.equals(gemHome)) {
            this.getLog().warn((CharSequence)("Using inherited external environment to resolve gems (" + gemHome + "), i.e. build is platform dependent!"));
        }
        return asciidoctor;
    }

    protected List<File> findSourceFiles(File sourceDirectory) {
        if (this.sourceDocumentName != null) {
            return Arrays.asList(new File(sourceDirectory, this.sourceDocumentName));
        }
        Path sourceDirectoryPath = sourceDirectory.toPath();
        SourceDocumentFinder finder = new SourceDocumentFinder();
        return this.sourceDocumentExtensions.isEmpty() ? finder.find(sourceDirectoryPath) : finder.find(sourceDirectoryPath, this.sourceDocumentExtensions);
    }

    protected void convertFile(Asciidoctor asciidoctor, Map<String, Object> options, File f) {
        asciidoctor.convertFile(f, options);
        this.logConvertedFile(f);
    }

    protected void logConvertedFile(File f) {
        this.getLog().info((CharSequence)("Converted " + f.getAbsolutePath()));
    }

    protected boolean ensureOutputExists() {
        if (!this.outputDirectory.exists()) {
            return this.outputDirectory.mkdirs();
        }
        return true;
    }

    protected OptionsBuilder createOptionsBuilder(AsciidoctorMojo configuration, AttributesBuilder attributesBuilder) {
        OptionsBuilder optionsBuilder = OptionsBuilder.options().backend(configuration.getBackend()).safe(SafeMode.UNSAFE).headerFooter(configuration.isHeaderFooter()).eruby(configuration.getEruby()).mkDirs(true);
        if (configuration.isSourcemap()) {
            optionsBuilder.option("sourcemap", (Object)true);
        }
        if (configuration.isCatalogAssets()) {
            optionsBuilder.option("catalog_assets", (Object)true);
        }
        if (!configuration.isTemplateCache()) {
            optionsBuilder.option("template_cache", (Object)false);
        }
        if (configuration.getDoctype() != null) {
            optionsBuilder.docType(this.doctype);
        }
        if (configuration.getTemplateEngine() != null) {
            optionsBuilder.templateEngine(this.templateEngine);
        }
        if (!configuration.getTemplateDirs().isEmpty()) {
            optionsBuilder.templateDirs(this.templateDirs.toArray(new File[0]));
        }
        if (!attributesBuilder.asMap().isEmpty()) {
            optionsBuilder.attributes(attributesBuilder);
        }
        return optionsBuilder;
    }

    protected AttributesBuilder createAttributesBuilder(AsciidoctorMojo configuration, MavenProject mavenProject) {
        AttributesBuilder attributesBuilder = AttributesBuilder.attributes();
        if (configuration.isEmbedAssets()) {
            attributesBuilder.linkCss(false);
            attributesBuilder.dataUri(true);
        }
        AsciidoctorHelper.addMavenProperties(mavenProject, attributesBuilder);
        AsciidoctorHelper.addAttributes(configuration.getAttributes(), attributesBuilder);
        if (!configuration.getAttributesChain().isEmpty()) {
            this.getLog().info((CharSequence)("Attributes: " + this.attributesChain));
            attributesBuilder.arguments(this.attributesChain);
        }
        return attributesBuilder;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = new File(outputFile);
    }

    public String getBackend() {
        return this.backend;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean isHeaderFooter() {
        return this.headerFooter;
    }

    public void setHeaderFooter(boolean headerFooter) {
        this.headerFooter = headerFooter;
    }

    public String getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(String templateEngine) {
        this.templateEngine = templateEngine;
    }

    public List<String> getSourceDocumentExtensions() {
        return this.sourceDocumentExtensions;
    }

    public void setSourceDocumentExtensions(List<String> sourceDocumentExtensions) {
        this.sourceDocumentExtensions = sourceDocumentExtensions;
    }

    public String getEruby() {
        return this.eruby;
    }

    public void setEruby(String eruby) {
        this.eruby = eruby;
    }

    public String getSourceDocumentName() {
        return this.sourceDocumentName;
    }

    public void setSourceDocumentName(String sourceDocumentName) {
        this.sourceDocumentName = sourceDocumentName;
    }

    public boolean isEmbedAssets() {
        return this.embedAssets;
    }

    public void setEmbedAssets(boolean embedAssets) {
        this.embedAssets = embedAssets;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public String getGemPath() {
        return this.gemPath;
    }

    public void setGemPath(String gemPath) {
        this.gemPath = gemPath;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setPreserveDirectories(boolean preserveDirectories) {
        this.preserveDirectories = preserveDirectories;
    }

    public void setRelativeBaseDir(boolean relativeBaseDir) {
        this.relativeBaseDir = relativeBaseDir;
    }

    public List<ExtensionConfiguration> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<ExtensionConfiguration> extensions) {
        this.extensions = extensions;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public boolean isEnableVerbose() {
        return this.enableVerbose;
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public void setEnableVerbose(boolean enableVerbose) {
        this.enableVerbose = enableVerbose;
    }

    public boolean isSourcemap() {
        return this.sourcemap;
    }

    public boolean isCatalogAssets() {
        return this.catalogAssets;
    }

    public boolean isTemplateCache() {
        return this.templateCache;
    }

    public List<File> getTemplateDirs() {
        return this.templateDirs;
    }

    public String getAttributesChain() {
        return this.attributesChain;
    }

    public boolean isRelativeBaseDir() {
        return this.relativeBaseDir;
    }

    public boolean isPreserveDirectories() {
        return this.preserveDirectories;
    }
}

