/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.extensions;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.extension.BlockMacroProcessor;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.DocinfoProcessor;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.InlineMacroProcessor;
import org.asciidoctor.extension.JavaExtensionRegistry;
import org.asciidoctor.extension.Postprocessor;
import org.asciidoctor.extension.Preprocessor;
import org.asciidoctor.extension.Treeprocessor;
import org.asciidoctor.maven.extensions.ExtensionRegistry;

public class AsciidoctorJExtensionRegistry
implements ExtensionRegistry {
    private JavaExtensionRegistry javaExtensionRegistry;

    public AsciidoctorJExtensionRegistry(Asciidoctor asciidoctorInstance) {
        this.javaExtensionRegistry = asciidoctorInstance.javaExtensionRegistry();
    }

    @Override
    public void register(String extensionClassName, String blockName) throws MojoExecutionException {
        Class<?> clazz;
        try {
            clazz = Class.forName(extensionClassName);
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("'" + extensionClassName + "' is not a valid AsciidoctorJ processor class");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("'" + extensionClassName + "' not found in classpath");
        }
        if (DocinfoProcessor.class.isAssignableFrom(clazz)) {
            this.register(this.javaExtensionRegistry, "docinfoProcessor", clazz);
        } else if (Preprocessor.class.isAssignableFrom(clazz)) {
            this.register(this.javaExtensionRegistry, "preprocessor", clazz);
        } else if (Postprocessor.class.isAssignableFrom(clazz)) {
            this.register(this.javaExtensionRegistry, "postprocessor", clazz);
        } else if (Treeprocessor.class.isAssignableFrom(clazz)) {
            this.register(this.javaExtensionRegistry, "treeprocessor", clazz);
        } else if (BlockProcessor.class.isAssignableFrom(clazz)) {
            if (blockName == null) {
                this.register(this.javaExtensionRegistry, "block", clazz);
            } else {
                this.register(this.javaExtensionRegistry, "block", blockName, clazz);
            }
        } else if (IncludeProcessor.class.isAssignableFrom(clazz)) {
            this.register(this.javaExtensionRegistry, "includeProcessor", clazz);
        } else if (BlockMacroProcessor.class.isAssignableFrom(clazz)) {
            if (blockName == null) {
                this.register(this.javaExtensionRegistry, "blockMacro", clazz);
            } else {
                this.register(this.javaExtensionRegistry, "blockMacro", blockName, clazz);
            }
        } else if (InlineMacroProcessor.class.isAssignableFrom(clazz)) {
            if (blockName == null) {
                this.register(this.javaExtensionRegistry, "inlineMacro", clazz);
            } else {
                this.register(this.javaExtensionRegistry, "inlineMacro", blockName, clazz);
            }
        }
    }

    private void register(Object target, String methodName, Object ... args) throws MojoExecutionException {
        for (Method method : this.javaExtensionRegistry.getClass().getMethods()) {
            if (!this.isMethodMatching(method, methodName, args)) continue;
            try {
                method.invoke(target, args);
                return;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unexpected exception while registering extensions", e);
            }
        }
        throw new MojoExecutionException("Internal Error. Could not register " + methodName + " with arguments " + Arrays.asList(args));
    }

    private boolean isMethodMatching(Method method, String methodName, Object[] args) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        if (method.getParameterTypes().length != args.length) {
            return false;
        }
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (args[i] == null || method.getParameterTypes()[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }
}

