/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;

public class RubyGemsPreloader {
    private static final String CODERAY = "coderay";
    private static final String ERUBIS = "erubis";
    private static final Map<String, String> optionToRequiredGem = new HashMap<String, String>(){
        {
            this.put("source-highlighter", "require 'coderay'");
            this.put("eruby", "require 'erubis'");
            this.put("template_dirs", "require 'tilt'");
            this.put("data-uri", "require 'base64'");
            this.put("cache-uri", "require 'open-uri/cached'");
        }
    };
    private Ruby rubyRuntime;

    public RubyGemsPreloader(Ruby rubyRuntime) {
        this.rubyRuntime = rubyRuntime;
    }

    public void preloadRequiredLibraries(Map<String, Object> options) {
        if (options.containsKey("attributes")) {
            Map attributes = (Map)options.get("attributes");
            if (this.isOptionSet(attributes, "source-highlighter") && this.isOptionWithValue(attributes, "source-highlighter", CODERAY)) {
                this.preloadLibrary("source-highlighter");
            }
            if (this.isOptionSet(attributes, "cache-uri")) {
                this.preloadLibrary("cache-uri");
            }
            if (this.isOptionSet(attributes, "data-uri")) {
                this.preloadLibrary("data-uri");
            }
        }
        if (this.isOptionSet(options, "eruby") && this.isOptionWithValue(options, "eruby", ERUBIS)) {
            this.preloadLibrary("eruby");
        }
        if (this.isOptionSet(options, "template_dirs")) {
            this.preloadLibrary("template_dirs");
        }
    }

    private void preloadLibrary(String option) {
        this.rubyRuntime.evalScriptlet(optionToRequiredGem.get(option));
    }

    private boolean isOptionWithValue(Map<String, Object> attributes, String attribute, String value) {
        return attributes.get(attribute).equals(value);
    }

    private boolean isOptionSet(Map<String, Object> attributes, String attribute) {
        return attributes.containsKey(attribute);
    }
}

