/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ContentPart;
import org.asciidoctor.DirectoryWalker;
import org.asciidoctor.DocumentHeader;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.StructuredDocument;
import org.asciidoctor.extension.ExtensionRegistryExecutor;
import org.asciidoctor.extension.JavaExtensionRegistry;
import org.asciidoctor.extension.RubyExtensionRegistry;
import org.asciidoctor.internal.AsciidoctorModule;
import org.asciidoctor.internal.AsciidoctorUtils;
import org.asciidoctor.internal.Block;
import org.asciidoctor.internal.Document;
import org.asciidoctor.internal.DocumentRuby;
import org.asciidoctor.internal.EnvironmentInjector;
import org.asciidoctor.internal.IOUtils;
import org.asciidoctor.internal.JRubyAsciidoctorModuleFactory;
import org.asciidoctor.internal.JRubyRuntimeContext;
import org.asciidoctor.internal.RubyGemsPreloader;
import org.asciidoctor.internal.RubyHashUtil;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.javasupport.JavaEmbedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRubyAsciidoctor
implements Asciidoctor {
    private static final Logger log = LoggerFactory.getLogger((String)JRubyAsciidoctor.class.getName());
    private static final String GEM_PATH = "GEM_PATH";
    private static final int DEFAULT_MAX_LEVEL = 1;
    private AsciidoctorModule asciidoctorModule;
    protected RubyGemsPreloader rubyGemsPreloader;
    protected Ruby rubyRuntime;

    private JRubyAsciidoctor(AsciidoctorModule asciidoctorModule, Ruby rubyRuntime) {
        this.asciidoctorModule = asciidoctorModule;
        this.rubyRuntime = rubyRuntime;
        this.rubyGemsPreloader = new RubyGemsPreloader(this.rubyRuntime);
    }

    public static Asciidoctor create() {
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(new HashMap<String, Object>());
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        return asciidoctor;
    }

    public static Asciidoctor create(String gemPath) {
        HashMap<String, Object> gemPathVar = new HashMap<String, Object>();
        gemPathVar.put(GEM_PATH, gemPath);
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(gemPathVar);
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        return asciidoctor;
    }

    public static Asciidoctor create(List<String> loadPaths) {
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(loadPaths);
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        return asciidoctor;
    }

    private static void registerExtensions(Asciidoctor asciidoctor) {
        new ExtensionRegistryExecutor(asciidoctor).registerAllExtensions();
    }

    private static Asciidoctor createJRubyAsciidoctorInstance(List<String> loadPaths) {
        RubyInstanceConfig config = JRubyAsciidoctor.createOptimizedConfiguration();
        Ruby rubyRuntime = JavaEmbedUtils.initialize(loadPaths, (RubyInstanceConfig)config);
        JRubyRuntimeContext.set(rubyRuntime);
        JRubyAsciidoctorModuleFactory jRubyAsciidoctorModuleFactory = new JRubyAsciidoctorModuleFactory(rubyRuntime);
        AsciidoctorModule asciidoctorModule = jRubyAsciidoctorModuleFactory.createAsciidoctorModule();
        JRubyAsciidoctor jRubyAsciidoctor = new JRubyAsciidoctor(asciidoctorModule, rubyRuntime);
        return jRubyAsciidoctor;
    }

    private static Asciidoctor createJRubyAsciidoctorInstance(Map<String, Object> environmentVars) {
        RubyInstanceConfig config = JRubyAsciidoctor.createOptimizedConfiguration();
        Ruby rubyRuntime = JavaEmbedUtils.initialize((List)Collections.EMPTY_LIST, (RubyInstanceConfig)config);
        JRubyAsciidoctor.injectEnvironmentVariables(rubyRuntime, environmentVars);
        JRubyRuntimeContext.set(rubyRuntime);
        JRubyAsciidoctorModuleFactory jRubyAsciidoctorModuleFactory = new JRubyAsciidoctorModuleFactory(rubyRuntime);
        AsciidoctorModule asciidoctorModule = jRubyAsciidoctorModuleFactory.createAsciidoctorModule();
        JRubyAsciidoctor jRubyAsciidoctor = new JRubyAsciidoctor(asciidoctorModule, rubyRuntime);
        return jRubyAsciidoctor;
    }

    private static void injectEnvironmentVariables(Ruby runtime, Map<String, Object> environmentVars) {
        EnvironmentInjector environmentInjector = new EnvironmentInjector(runtime);
        environmentInjector.inject(environmentVars);
    }

    private static RubyInstanceConfig createOptimizedConfiguration() {
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.setCompatVersion(CompatVersion.RUBY1_9);
        config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
        return config;
    }

    private static DocumentHeader toDocumentHeader(DocumentRuby documentRuby) {
        return DocumentHeader.createDocumentHeader(documentRuby.doctitle(), documentRuby.title(), documentRuby.getAttributes());
    }

    private StructuredDocument toDocument(DocumentRuby documentRuby, Ruby rubyRuntime, int maxDeepLevel) {
        Document document = new Document(documentRuby, rubyRuntime);
        List<ContentPart> contentParts = this.getContents(document.blocks(), 1, maxDeepLevel);
        return StructuredDocument.createStructuredDocument(JRubyAsciidoctor.toDocumentHeader(documentRuby), contentParts);
    }

    private List<ContentPart> getContents(List<Block> blocks, int level, int maxDeepLevel) {
        if (level > maxDeepLevel) {
            return null;
        }
        if (blocks.size() == 1 && blocks.get(0).blocks().size() > 0) {
            return this.getContents(blocks.get(0).blocks(), 0, maxDeepLevel);
        }
        ArrayList<ContentPart> parts = new ArrayList<ContentPart>();
        for (Block block : blocks) {
            parts.add(this.getContentPartFromBlock(block, level, maxDeepLevel));
        }
        return parts;
    }

    private ContentPart getContentPartFromBlock(Block child, int level, int maxDeepLevel) {
        Object content = child.content();
        String textContent = content instanceof String ? (String)content : child.render();
        ContentPart contentPart = ContentPart.createContentPart(child.id(), level, child.context(), child.title(), child.style(), child.role(), child.attributes(), textContent);
        contentPart.setParts(this.getContents(child.blocks(), level + 1, maxDeepLevel));
        return contentPart;
    }

    @Override
    public StructuredDocument readDocumentStructure(File filename, Map<String, Object> options) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        DocumentRuby documentRuby = this.asciidoctorModule.load_file(filename.getAbsolutePath(), (Map<String, Object>)rubyHash);
        int maxDeepLevel = options.containsKey("STRUCTURE_MAX_LEVEL") ? (Integer)options.get("STRUCTURE_MAX_LEVEL") : 1;
        return this.toDocument(documentRuby, this.rubyRuntime, maxDeepLevel);
    }

    @Override
    public StructuredDocument readDocumentStructure(String content, Map<String, Object> options) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        DocumentRuby documentRuby = this.asciidoctorModule.load(content, (Map<String, Object>)rubyHash);
        int maxDeepLevel = options.containsKey("STRUCTURE_MAX_LEVEL") ? (Integer)options.get("STRUCTURE_MAX_LEVEL") : 1;
        return this.toDocument(documentRuby, this.rubyRuntime, maxDeepLevel);
    }

    @Override
    public StructuredDocument readDocumentStructure(Reader contentReader, Map<String, Object> options) {
        String content = IOUtils.readFull(contentReader);
        return this.readDocumentStructure(content, options);
    }

    @Override
    public DocumentHeader readDocumentHeader(File filename) {
        RubyHash rubyHash = this.getParseHeaderOnlyOption();
        DocumentRuby documentRuby = this.asciidoctorModule.load_file(filename.getAbsolutePath(), (Map<String, Object>)rubyHash);
        return JRubyAsciidoctor.toDocumentHeader(documentRuby);
    }

    @Override
    public DocumentHeader readDocumentHeader(String content) {
        RubyHash rubyHash = this.getParseHeaderOnlyOption();
        DocumentRuby documentRuby = this.asciidoctorModule.load(content, (Map<String, Object>)rubyHash);
        return JRubyAsciidoctor.toDocumentHeader(documentRuby);
    }

    @Override
    public DocumentHeader readDocumentHeader(Reader contentReader) {
        String content = IOUtils.readFull(contentReader);
        return this.readDocumentHeader(content);
    }

    private RubyHash getParseHeaderOnlyOption() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("parse_header_only", true);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        return rubyHash;
    }

    @Override
    public String render(String content, Map<String, Object> options) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options);
        if (log.isDebugEnabled()) {
            log.debug(AsciidoctorUtils.toAsciidoctorComamnd(options, "-"));
            if (AsciidoctorUtils.isOptionWithAttribute(options, "source-highlighter", "pygments")) {
                log.debug("In order to use Pygments with Asciidoctor, you need to install Pygments (and Python, if you don\u2019t have it yet). Read http://asciidoctor.org/news/#syntax-highlighting-with-pygments.");
            }
        }
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        Object object = this.asciidoctorModule.render(content, (Map<String, Object>)rubyHash);
        return this.returnExpectedValue(object);
    }

    @Override
    public String renderFile(File filename, Map<String, Object> options) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options);
        if (log.isDebugEnabled()) {
            log.debug(AsciidoctorUtils.toAsciidoctorComamnd(options, filename.getAbsolutePath()));
        }
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        Object object = this.asciidoctorModule.render_file(filename.getAbsolutePath(), (Map<String, Object>)rubyHash);
        return this.returnExpectedValue(object);
    }

    private String returnExpectedValue(Object object) {
        if (object instanceof String) {
            return object.toString();
        }
        return null;
    }

    @Override
    public void render(Reader contentReader, Writer rendererWriter, Map<String, Object> options) throws IOException {
        String content = IOUtils.readFull(contentReader);
        String renderedContent = this.render(content, options);
        IOUtils.writeFull(rendererWriter, renderedContent);
    }

    @Override
    public String[] renderFiles(Collection<File> asciidoctorFiles, Map<String, Object> options) {
        List<String> asciidoctorContent = this.renderAllFiles(options, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[asciidoctorContent.size()]);
    }

    @Override
    public String[] renderFiles(Collection<File> asciidoctorFiles, Options options) {
        return this.renderFiles(asciidoctorFiles, options.map());
    }

    @Override
    public String[] renderDirectory(DirectoryWalker directoryWalker, Map<String, Object> options) {
        List<File> asciidoctorFiles = this.scanForAsciiDocFiles(directoryWalker);
        List<String> asciidoctorContent = this.renderAllFiles(options, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[asciidoctorContent.size()]);
    }

    private List<String> renderAllFiles(Map<String, Object> options, Collection<File> asciidoctorFiles) {
        ArrayList<String> asciidoctorContent = new ArrayList<String>();
        for (File asciidoctorFile : asciidoctorFiles) {
            String renderedFile = this.renderFile(asciidoctorFile, options);
            if (renderedFile == null) continue;
            asciidoctorContent.add(renderedFile);
        }
        return asciidoctorContent;
    }

    private List<File> scanForAsciiDocFiles(DirectoryWalker directoryWalker) {
        List<File> asciidoctorFiles = directoryWalker.scan();
        return asciidoctorFiles;
    }

    @Override
    public String render(String content, Options options) {
        return this.render(content, options.map());
    }

    @Override
    public void render(Reader contentReader, Writer rendererWriter, Options options) throws IOException {
        this.render(contentReader, rendererWriter, options.map());
    }

    @Override
    public String renderFile(File filename, Options options) {
        return this.renderFile(filename, options.map());
    }

    @Override
    public String[] renderDirectory(DirectoryWalker directoryWalker, Options options) {
        return this.renderDirectory(directoryWalker, options.map());
    }

    @Override
    public String render(String content, OptionsBuilder options) {
        return this.render(content, options.asMap());
    }

    @Override
    public void render(Reader contentReader, Writer rendererWriter, OptionsBuilder options) throws IOException {
        this.render(contentReader, rendererWriter, options.asMap());
    }

    @Override
    public String renderFile(File filename, OptionsBuilder options) {
        return this.renderFile(filename, options.asMap());
    }

    @Override
    public String[] renderDirectory(DirectoryWalker directoryWalker, OptionsBuilder options) {
        return this.renderDirectory(directoryWalker, options.asMap());
    }

    @Override
    public String[] renderFiles(Collection<File> asciidoctorFiles, OptionsBuilder options) {
        return this.renderFiles(asciidoctorFiles, options.asMap());
    }

    @Override
    public JavaExtensionRegistry javaExtensionRegistry() {
        return new JavaExtensionRegistry(this.asciidoctorModule, this.rubyRuntime);
    }

    @Override
    public RubyExtensionRegistry rubyExtensionRegistry() {
        return new RubyExtensionRegistry(this.asciidoctorModule, this.rubyRuntime);
    }

    @Override
    public void unregisterAllExtensions() {
        this.asciidoctorModule.unregister_all_extensions();
    }

    @Override
    public void shutdown() {
        this.rubyRuntime.tearDown();
    }

    @Override
    public String asciidoctorVersion() {
        return this.asciidoctorModule.asciidoctorRuntimeEnvironmentVersion();
    }
}

