/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.extension;

import org.asciidoctor.extension.BlockMacroProcessor;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.InlineMacroProcessor;
import org.asciidoctor.extension.Postprocessor;
import org.asciidoctor.extension.Preprocessor;
import org.asciidoctor.extension.Treeprocessor;
import org.asciidoctor.internal.AsciidoctorModule;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;

public class JavaExtensionRegistry {
    private AsciidoctorModule asciidoctorModule;
    private Ruby rubyRuntime;

    public JavaExtensionRegistry(AsciidoctorModule asciidoctorModule, Ruby rubyRuntime) {
        this.asciidoctorModule = asciidoctorModule;
        this.rubyRuntime = rubyRuntime;
    }

    public void preprocessor(Class<? extends Preprocessor> preprocessor) {
        this.rubyRuntime.evalScriptlet("java_import " + this.getImportLine(preprocessor));
        this.asciidoctorModule.preprocessor(preprocessor.getSimpleName());
    }

    public void postprocessor(Class<? extends Postprocessor> postprocesor) {
        this.rubyRuntime.evalScriptlet("java_import " + this.getImportLine(postprocesor));
        this.asciidoctorModule.postprocessor(postprocesor.getSimpleName());
    }

    public void includeProcessor(Class<? extends IncludeProcessor> includeProcessor) {
        this.rubyRuntime.evalScriptlet("java_import " + this.getImportLine(includeProcessor));
        this.asciidoctorModule.include_processor(includeProcessor.getSimpleName());
    }

    public void treeprocessor(Class<? extends Treeprocessor> treeProcessor) {
        this.rubyRuntime.evalScriptlet("java_import " + this.getImportLine(treeProcessor));
        this.asciidoctorModule.treeprocessor(treeProcessor.getSimpleName());
    }

    public void block(String blockName, Class<? extends BlockProcessor> blockProcessor) {
        this.rubyRuntime.evalScriptlet("java_import " + this.getImportLine(blockProcessor));
        try {
            blockProcessor.getMethod("setup", Ruby.class).invoke(null, this.rubyRuntime);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke setup method on block processor class: " + blockProcessor, e);
        }
        this.asciidoctorModule.block_processor(RubyUtils.toSymbol(this.rubyRuntime, blockName), blockProcessor.getSimpleName());
    }

    public void blockMacro(String blockName, Class<? extends BlockMacroProcessor> blockMacroProcessor) {
        this.rubyRuntime.evalScriptlet("java_import " + this.getImportLine(blockMacroProcessor));
        this.asciidoctorModule.block_macro(RubyUtils.toSymbol(this.rubyRuntime, blockName), blockMacroProcessor.getSimpleName());
    }

    public void inlineMacro(String blockName, Class<? extends InlineMacroProcessor> inlineMacroProcessor) {
        this.rubyRuntime.evalScriptlet("java_import " + this.getImportLine(inlineMacroProcessor));
        this.asciidoctorModule.inline_macro(RubyUtils.toSymbol(this.rubyRuntime, blockName), inlineMacroProcessor.getSimpleName());
    }

    private String getImportLine(Class<?> extensionClass) {
        return extensionClass.getName().replace("$", "::");
    }
}

