/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.DirectoryWalker;
import org.asciidoctor.DocumentHeader;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.extension.ExtensionRegistry;
import org.asciidoctor.internal.AsciidoctorModule;
import org.asciidoctor.internal.DocumentRuby;
import org.asciidoctor.internal.EnvironmentInjector;
import org.asciidoctor.internal.IOUtils;
import org.asciidoctor.internal.JRubyAsciidoctorModuleFactory;
import org.asciidoctor.internal.RubyGemsPreloader;
import org.asciidoctor.internal.RubyHashUtil;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.javasupport.JavaEmbedUtils;

public class JRubyAsciidoctor
implements Asciidoctor {
    private static final String GEM_PATH = "GEM_PATH";
    private AsciidoctorModule asciidoctorModule;
    protected RubyGemsPreloader rubyGemsPreloader;
    protected Ruby rubyRuntime;

    private JRubyAsciidoctor(AsciidoctorModule asciidoctorModule, Ruby rubyRuntime) {
        this.asciidoctorModule = asciidoctorModule;
        this.rubyRuntime = rubyRuntime;
        this.rubyGemsPreloader = new RubyGemsPreloader(this.rubyRuntime);
    }

    public static Asciidoctor create() {
        return JRubyAsciidoctor.createJRubyAsciidoctorInstance(new HashMap<String, Object>());
    }

    public static Asciidoctor create(String gemPath) {
        HashMap<String, Object> gemPathVar = new HashMap<String, Object>();
        gemPathVar.put(GEM_PATH, gemPath);
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(gemPathVar);
        return asciidoctor;
    }

    private static Asciidoctor createJRubyAsciidoctorInstance(Map<String, Object> environmentVars) {
        RubyInstanceConfig config = JRubyAsciidoctor.createOptimizedConfiguration();
        Ruby rubyRuntime = JavaEmbedUtils.initialize((List)Collections.EMPTY_LIST, (RubyInstanceConfig)config);
        JRubyAsciidoctor.injectEnvironmentVariables(rubyRuntime, environmentVars);
        JRubyAsciidoctorModuleFactory jRubyAsciidoctorModuleFactory = new JRubyAsciidoctorModuleFactory(rubyRuntime);
        AsciidoctorModule asciidoctorModule = jRubyAsciidoctorModuleFactory.createAsciidoctorModule();
        JRubyAsciidoctor jRubyAsciidoctor = new JRubyAsciidoctor(asciidoctorModule, rubyRuntime);
        return jRubyAsciidoctor;
    }

    private static void injectEnvironmentVariables(Ruby runtime, Map<String, Object> environmentVars) {
        EnvironmentInjector environmentInjector = new EnvironmentInjector(runtime);
        environmentInjector.inject(environmentVars);
    }

    private static RubyInstanceConfig createOptimizedConfiguration() {
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.setCompatVersion(CompatVersion.RUBY1_9);
        config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
        return config;
    }

    private static DocumentHeader toDocumentHeader(DocumentRuby documentRuby) {
        return DocumentHeader.createDocumentHeader(documentRuby.doctitle(), documentRuby.title(), documentRuby.getAttributes());
    }

    @Override
    public DocumentHeader readDocumentHeader(File filename) {
        RubyHash rubyHash = this.getParseHeaderOnlyOption();
        DocumentRuby documentRuby = this.asciidoctorModule.load_file(filename.getAbsolutePath(), (Map<String, Object>)rubyHash);
        return JRubyAsciidoctor.toDocumentHeader(documentRuby);
    }

    @Override
    public DocumentHeader readDocumentHeader(String content) {
        RubyHash rubyHash = this.getParseHeaderOnlyOption();
        DocumentRuby documentRuby = this.asciidoctorModule.load(content, (Map<String, Object>)rubyHash);
        return JRubyAsciidoctor.toDocumentHeader(documentRuby);
    }

    @Override
    public DocumentHeader readDocumentHeader(Reader contentReader) {
        String content = IOUtils.readFull(contentReader);
        return this.readDocumentHeader(content);
    }

    private RubyHash getParseHeaderOnlyOption() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("parse_header_only", true);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        return rubyHash;
    }

    @Override
    public String render(String content, Map<String, Object> options) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options);
        this.addRubyRuntimeAsAttribute(options);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        Object object = this.asciidoctorModule.render(content, (Map<String, Object>)rubyHash);
        return this.returnExpectedValue(object);
    }

    @Override
    public String renderFile(File filename, Map<String, Object> options) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options);
        this.addRubyRuntimeAsAttribute(options);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        Object object = this.asciidoctorModule.render_file(filename.getAbsolutePath(), (Map<String, Object>)rubyHash);
        return this.returnExpectedValue(object);
    }

    private void addRubyRuntimeAsAttribute(Map<String, Object> options) {
        if (options.containsKey("attributes")) {
            ((Map)options.get("attributes")).put("jruby", this.rubyRuntime);
        } else {
            options.put("attributes", new HashMap<String, Object>(){
                {
                    this.put("jruby", JRubyAsciidoctor.this.rubyRuntime);
                }
            });
        }
    }

    private Map<String, Object> removeCopyCssAttribute(Map<String, Object> attributes) {
        attributes.remove("copycss");
        return attributes;
    }

    private String returnExpectedValue(Object object) {
        if (object instanceof String) {
            return object.toString();
        }
        return null;
    }

    @Override
    public void render(Reader contentReader, Writer rendererWriter, Map<String, Object> options) throws IOException {
        String content = IOUtils.readFull(contentReader);
        String renderedContent = this.render(content, options);
        IOUtils.writeFull(rendererWriter, renderedContent);
    }

    @Override
    public String[] renderFiles(Collection<File> asciidoctorFiles, Map<String, Object> options) {
        List<String> asciidoctorContent = this.renderAllFiles(options, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[asciidoctorContent.size()]);
    }

    @Override
    public String[] renderFiles(Collection<File> asciidoctorFiles, Options options) {
        return this.renderFiles(asciidoctorFiles, options.map());
    }

    @Override
    public String[] renderDirectory(DirectoryWalker directoryWalker, Map<String, Object> options) {
        List<File> asciidoctorFiles = this.scanForAsciiDocFiles(directoryWalker);
        List<String> asciidoctorContent = this.renderAllFiles(options, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[asciidoctorContent.size()]);
    }

    private List<String> renderAllFiles(Map<String, Object> options, Collection<File> asciidoctorFiles) {
        ArrayList<String> asciidoctorContent = new ArrayList<String>();
        for (File asciidoctorFile : asciidoctorFiles) {
            String renderedFile = this.renderFile(asciidoctorFile, options);
            if (renderedFile == null) continue;
            asciidoctorContent.add(renderedFile);
        }
        return asciidoctorContent;
    }

    private List<File> scanForAsciiDocFiles(DirectoryWalker directoryWalker) {
        List<File> asciidoctorFiles = directoryWalker.scan();
        return asciidoctorFiles;
    }

    @Override
    public String render(String content, Options options) {
        return this.render(content, options.map());
    }

    @Override
    public void render(Reader contentReader, Writer rendererWriter, Options options) throws IOException {
        this.render(contentReader, rendererWriter, options.map());
    }

    @Override
    public String renderFile(File filename, Options options) {
        return this.renderFile(filename, options.map());
    }

    @Override
    public String[] renderDirectory(DirectoryWalker directoryWalker, Options options) {
        return this.renderDirectory(directoryWalker, options.map());
    }

    @Override
    public String render(String content, OptionsBuilder options) {
        return this.render(content, options.asMap());
    }

    @Override
    public void render(Reader contentReader, Writer rendererWriter, OptionsBuilder options) throws IOException {
        this.render(contentReader, rendererWriter, options.asMap());
    }

    @Override
    public String renderFile(File filename, OptionsBuilder options) {
        return this.renderFile(filename, options.asMap());
    }

    @Override
    public String[] renderDirectory(DirectoryWalker directoryWalker, OptionsBuilder options) {
        return this.renderDirectory(directoryWalker, options.asMap());
    }

    @Override
    public String[] renderFiles(Collection<File> asciidoctorFiles, OptionsBuilder options) {
        return this.renderFiles(asciidoctorFiles, options.asMap());
    }

    @Override
    public ExtensionRegistry extensionRegistry() {
        return new ExtensionRegistry(this.asciidoctorModule, this.rubyRuntime);
    }
}

