/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.gradle.remote;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.gradle.internal.ExecutorLogLevel;
import org.asciidoctor.gradle.remote.AsciidoctorRemoteExecutionException;
import org.asciidoctor.gradle.remote.LogSeverityMapper;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciidoctorJLogProcessor
implements Serializable,
GroovyObject {
    private int maxSeverityLevel;
    private final int failureLevel;
    private final List<String> warningMessages;
    private final List<Pattern> messagePatterns;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AsciidoctorJLogProcessor(int maxSeverityLevel, int failureLevel) {
        int n;
        int n2;
        MetaClass metaClass;
        List list;
        List list2;
        this.warningMessages = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.messagePatterns = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.maxSeverityLevel = n2 = maxSeverityLevel;
        this.failureLevel = n = failureLevel;
    }

    public void failOnWarnings() {
        if (!this.warningMessages.isEmpty()) {
            String msg = StringGroovyMethods.plus((String)"ERROR: The following messages from AsciidoctorJ are treated as errors:\n", (CharSequence)DefaultGroovyMethods.join(this.warningMessages, (String)"\n- "));
            throw (Throwable)new AsciidoctorRemoteExecutionException(msg);
        }
    }

    public void failOnFailureLevelReachedOrExceeded() {
        if (this.maxSeverityLevel >= this.failureLevel) {
            Severity maxSeverity = LogSeverityMapper.getSeverityOf(this.maxSeverityLevel);
            Severity failureSeverity = LogSeverityMapper.getSeverityOf(this.failureLevel);
            throw (Throwable)new AsciidoctorRemoteExecutionException(StringGroovyMethods.plus((String)"ERROR: Failure level reached or exceeded: ", (CharSequence)new GStringImpl(new Object[]{maxSeverity, failureSeverity}, new String[]{"", " >= ", ""})));
        }
    }

    public LogHandler getLogHandler(ExecutorLogLevel required) {
        Reference requiredLevel = new Reference((Object)required.getLevel());
        return new LogHandler(this, requiredLevel){
            public /* synthetic */ Reference requiredLevel;
            final /* synthetic */ AsciidoctorJLogProcessor this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                AsciidoctorJLogProcessor asciidoctorJLogProcessor;
                this.this$0 = asciidoctorJLogProcessor = p0;
                this.requiredLevel = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void log(LogRecord logRecord) {
                ExecutorLogLevel logLevel = LogSeverityMapper.translateAsciidoctorLogLevel(logRecord.getSeverity());
                if (logLevel.getLevel() > this.this$0.maxSeverityLevel) {
                    AsciidoctorJLogProcessor.pfaccess$00(this.this$0, logLevel.getLevel());
                }
                if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)logLevel.getLevel(), (Object)this.requiredLevel.get())) {
                    String msg = logRecord.getMessage();
                    Cursor cursor = logRecord.getCursor();
                    if (DefaultTypeTransformation.booleanUnbox((Object)cursor)) {
                        String string = cursor.getPath();
                        String cPath = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
                        String string2 = cursor.getDir();
                        String cDir = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : "";
                        String string3 = cursor.getFile();
                        String cFile = DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : "";
                        String cLine = cursor.getLineNumber() >= 0 ? Integer.valueOf(cursor.getLineNumber()).toString() : "";
                        GStringImpl gStringImpl = new GStringImpl(new Object[]{msg, cPath, cDir, cFile, cLine}, new String[]{"", " :: ", " :: ", "/", ":", ""});
                        msg = ShortTypeHandling.castToString((Object)gStringImpl);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)logRecord.getSourceFileName())) {
                        String subMsg = DefaultTypeTransformation.booleanUnbox((Object)logRecord.getSourceMethodName()) ? StringGroovyMethods.plus((String)":", (CharSequence)logRecord.getSourceMethodName()) : "";
                        GStringImpl gStringImpl = new GStringImpl(new Object[]{msg, logRecord.getSourceFileName(), subMsg}, new String[]{"", " (", "", ")"});
                        msg = ShortTypeHandling.castToString((Object)gStringImpl);
                    }
                    this.this$0.logMessage(logLevel, msg);
                }
                this.this$0.addMatchingMessage(logRecord.getMessage());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, AsciidoctorJLogProcessor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, AsciidoctorJLogProcessor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(1.class, AsciidoctorJLogProcessor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                this.this$0.this$dist$set$1(name, value);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AsciidoctorJLogProcessor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, AsciidoctorJLogProcessor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        };
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public void logMessage(ExecutorLogLevel level, String msg) {
        block1: {
            ExecutorLogLevel executorLogLevel;
            block4: {
                block3: {
                    block2: {
                        block0: {
                            executorLogLevel = level;
                            if (!ScriptBytecodeAdapter.isCase((Object)executorLogLevel, (Object)ExecutorLogLevel.DEBUG)) break block0;
                            log.debug(msg);
                            break block1;
                        }
                        if (!ScriptBytecodeAdapter.isCase((Object)executorLogLevel, (Object)ExecutorLogLevel.INFO)) break block2;
                        log.info(msg);
                        break block1;
                    }
                    if (!ScriptBytecodeAdapter.isCase((Object)executorLogLevel, (Object)ExecutorLogLevel.WARN)) break block3;
                    log.warn(msg);
                    break block1;
                }
                if (!ScriptBytecodeAdapter.isCase((Object)executorLogLevel, (Object)ExecutorLogLevel.ERROR)) break block4;
                log.error(msg);
                break block1;
            }
            if (!ScriptBytecodeAdapter.isCase((Object)executorLogLevel, (Object)ExecutorLogLevel.QUIET)) break block1;
            log.error(msg);
        }
    }

    public void resetMessagePatternsTo(List<Pattern> patterns) {
        this.messagePatterns.clear();
        this.messagePatterns.addAll(patterns);
    }

    private void addMatchingMessage(String msg) {
        Reference msg2 = new Reference((Object)msg);
        public final class _addMatchingMessage_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference msg;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addMatchingMessage_closure1(Object _outerInstance, Object _thisObject, Reference msg) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.msg = reference = msg;
            }

            public Matcher doCall(Object it) {
                return (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)this.msg.get(), (Object)it), Matcher.class);
            }

            @Generated
            public String getMsg() {
                return ShortTypeHandling.castToString((Object)this.msg.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Matcher doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addMatchingMessage_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        if (!this.messagePatterns.isEmpty() && DefaultGroovyMethods.any(this.messagePatterns, (Closure)new _addMatchingMessage_closure1(this, this, msg2))) {
            this.warningMessages.add((String)msg2.get());
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AsciidoctorJLogProcessor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AsciidoctorJLogProcessor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AsciidoctorJLogProcessor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AsciidoctorJLogProcessor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AsciidoctorJLogProcessor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AsciidoctorJLogProcessor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ int pfaccess$00(AsciidoctorJLogProcessor $that, int $value) {
        int n;
        $that.maxSeverityLevel = n = $value;
        return n;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.asciidoctor.gradle.remote.AsciidoctorJLogProcessor");
    }
}

