/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.gradle.remote;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.gradle.internal.ExecutorConfiguration;
import org.asciidoctor.gradle.internal.ExecutorConfigurationContainer;
import org.asciidoctor.gradle.internal.ExecutorLogLevel;
import org.asciidoctor.gradle.remote.AsciidoctorJSetup;
import org.asciidoctor.gradle.remote.AsciidoctorRemoteExecutionException;
import org.asciidoctor.gradle.remote.LogSeverityMapper;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public abstract class ExecutorBase
implements GroovyObject {
    private final List<String> warningMessages;
    private final List<Pattern> messagePatterns;
    private final AsciidoctorJSetup setup;
    protected int maxSeverityLevel;
    protected int failureLevel;
    protected final List<ExecutorConfiguration> runConfigurations;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected ExecutorBase(ExecutorConfigurationContainer execConfig) {
        MetaClass metaClass;
        int n;
        int n2;
        AsciidoctorJSetup asciidoctorJSetup;
        List list;
        List list2;
        this.warningMessages = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.messagePatterns = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.setup = asciidoctorJSetup = new AsciidoctorJSetup();
        this.maxSeverityLevel = n2 = 0;
        this.failureLevel = n = 4;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        List<ExecutorConfiguration> list3 = execConfig.getConfigurations();
        this.runConfigurations = list3;
    }

    protected Map<String, Object> normalisedOptionsFor(File file, ExecutorConfiguration runConfiguration) {
        return this.setup.normalisedOptionsFor(file, runConfiguration);
    }

    protected String getRelativePath(File target, File base) throws IOException {
        return this.setup.getRelativePath(target, base);
    }

    protected List<Object> rehydrateExtensions(Object registry, List<Object> exts) {
        return this.setup.rehydrateExtensions(registry, exts);
    }

    protected LogHandler getLogHandler(ExecutorLogLevel required) {
        Reference requiredLevel = new Reference((Object)required.getLevel());
        return new LogHandler(this, requiredLevel){
            public /* synthetic */ Reference requiredLevel;
            final /* synthetic */ ExecutorBase this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                ExecutorBase executorBase;
                this.this$0 = executorBase = p0;
                this.requiredLevel = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void log(LogRecord logRecord) {
                ExecutorLogLevel logLevel = LogSeverityMapper.translateAsciidoctorLogLevel(logRecord.getSeverity());
                if (logLevel.getLevel() > DefaultTypeTransformation.intUnbox((Object)this.getProperty("maxSeverityLevel"))) {
                    int n = logLevel.getLevel();
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, 1.class, (GroovyObject)this, (String)"maxSeverityLevel");
                }
                if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)logLevel.getLevel(), (Object)this.requiredLevel.get())) {
                    String msg = logRecord.getMessage();
                    Cursor cursor = logRecord.getCursor();
                    if (DefaultTypeTransformation.booleanUnbox((Object)cursor)) {
                        String string = cursor.getPath();
                        String cPath = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
                        String string2 = cursor.getDir();
                        String cDir = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : "";
                        String string3 = cursor.getFile();
                        String cFile = DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : "";
                        String cLine = cursor.getLineNumber() >= 0 ? Integer.valueOf(cursor.getLineNumber()).toString() : "";
                        GStringImpl gStringImpl = new GStringImpl(new Object[]{msg, cPath, cDir, cFile, cLine}, new String[]{"", " :: ", " :: ", "/", ":", ""});
                        msg = ShortTypeHandling.castToString((Object)gStringImpl);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)logRecord.getSourceFileName())) {
                        String subMsg = DefaultTypeTransformation.booleanUnbox((Object)logRecord.getSourceMethodName()) ? StringGroovyMethods.plus((String)":", (CharSequence)logRecord.getSourceMethodName()) : "";
                        GStringImpl gStringImpl = new GStringImpl(new Object[]{msg, logRecord.getSourceFileName(), subMsg}, new String[]{"", " (", "", ")"});
                        msg = ShortTypeHandling.castToString((Object)gStringImpl);
                    }
                    this.this$0.logMessage(logLevel, msg);
                }
                this.this$0.addMatchingMessage(logRecord.getMessage());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, ExecutorBase.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, ExecutorBase.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ExecutorBase.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                this.this$0.this$dist$set$1(name, value);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ExecutorBase.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, ExecutorBase.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        };
    }

    protected abstract void logMessage(ExecutorLogLevel var1, String var2);

    protected void addMatchingMessage(String msg) {
        Reference msg2 = new Reference((Object)msg);
        public final class _addMatchingMessage_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference msg;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addMatchingMessage_closure1(Object _outerInstance, Object _thisObject, Reference msg) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.msg = reference = msg;
            }

            public Matcher doCall(Object it) {
                return (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)this.msg.get(), (Object)it), Matcher.class);
            }

            @Generated
            public String getMsg() {
                return ShortTypeHandling.castToString((Object)this.msg.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Matcher doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addMatchingMessage_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        if (!this.messagePatterns.isEmpty() && DefaultGroovyMethods.any(this.messagePatterns, (Closure)new _addMatchingMessage_closure1(this, this, msg2))) {
            this.warningMessages.add((String)msg2.get());
        }
    }

    protected List<String> getWarningMessages() {
        return this.warningMessages;
    }

    protected void resetMessagePatternsTo(List<Pattern> patterns) {
        this.messagePatterns.clear();
        this.messagePatterns.addAll(patterns);
    }

    protected void failOnWarnings() {
        if (!this.warningMessages.isEmpty()) {
            String msg = StringGroovyMethods.plus((String)"ERROR: The following messages from AsciidoctorJ are treated as errors:\n", (CharSequence)DefaultGroovyMethods.join(this.warningMessages, (String)"\n- "));
            throw (Throwable)new AsciidoctorRemoteExecutionException(msg);
        }
    }

    protected void failOnFailureLevelReachedOrExceeded() {
        if (this.maxSeverityLevel >= this.failureLevel) {
            Severity maxSeverity = LogSeverityMapper.getSeverityOf(this.maxSeverityLevel);
            Severity failureSeverity = LogSeverityMapper.getSeverityOf(this.failureLevel);
            throw (Throwable)new AsciidoctorRemoteExecutionException(StringGroovyMethods.plus((String)"ERROR: Failure level reached or exceeded: ", (CharSequence)new GStringImpl(new Object[]{maxSeverity, failureSeverity}, new String[]{"", " >= ", ""})));
        }
    }

    protected int findHighestFailureLevel(Iterable<Integer> levels) {
        return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.min(levels), Integer.TYPE));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ExecutorBase.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ExecutorBase.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ExecutorBase.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ExecutorBase.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ExecutorBase.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ExecutorBase.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

