/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.utils;

import java.io.File;
import org.artifactory.version.ArtifactoryVersion;
import org.artifactory.version.ArtifactoryVersionReader;

public abstract class BackupUtils {
    private BackupUtils() {
    }

    public static ArtifactoryVersion findVersion(File backupFolder) {
        if (backupFolder == null || !backupFolder.exists()) {
            throw new IllegalArgumentException("Cannot find Artifactory of null or non existent folder");
        }
        File propFile = new File(backupFolder, "artifactory.properties");
        if (!propFile.exists()) {
            throw new IllegalArgumentException("Backup folder " + backupFolder.getAbsolutePath() + " does not contain file : " + propFile.getName());
        }
        return ArtifactoryVersionReader.readFromFileAndFindVersion((File)propFile).getVersion();
    }
}

