/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.security.v6;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.artifactory.version.converter.XmlConverter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class LowercaseUsernameXmlConverter
implements XmlConverter {
    public void convert(Document doc) {
        Element root = doc.getRootElement();
        Namespace namespace = root.getNamespace();
        this.mergeGroups(root, namespace);
        this.mergeUsers(root, namespace);
        this.mergeAcls(root, namespace);
    }

    private void mergeUsers(Element root, Namespace namespace) {
        Element child = root.getChild("users", namespace);
        List users = child.getChildren("user", namespace);
        HashMap usernameToGroups = Maps.newHashMap();
        if (users != null && !users.isEmpty()) {
            Iterator iterator = users.iterator();
            while (iterator.hasNext()) {
                Element userElement = (Element)iterator.next();
                Element userNameElement = userElement.getChild("username", namespace);
                String userName = userNameElement.getText();
                String lowerCaseUsername = userName.toLowerCase();
                userNameElement.setText(lowerCaseUsername);
                if (!usernameToGroups.containsKey(lowerCaseUsername)) {
                    usernameToGroups.put(lowerCaseUsername, userElement);
                    this.addGroupsToUser(userElement, userElement, namespace);
                    this.copyEmails(namespace, usernameToGroups, userElement, lowerCaseUsername);
                    continue;
                }
                String isAdmin = userElement.getChild("admin").getText();
                Element existingUserElement = (Element)usernameToGroups.get(lowerCaseUsername);
                this.addGroupsToUser(existingUserElement, userElement, namespace);
                if (Boolean.parseBoolean(isAdmin)) {
                    usernameToGroups.put(lowerCaseUsername, userElement);
                }
                this.copyEmails(namespace, usernameToGroups, existingUserElement, lowerCaseUsername);
                this.addGroupsToUser(userElement, existingUserElement, namespace);
                iterator.remove();
            }
        }
        root.removeChildren("users", namespace);
        Element usersElement = new Element("users", namespace);
        root.addContent((Content)usersElement);
        for (Map.Entry elementEntry : usernameToGroups.entrySet()) {
            Element newUser = (Element)elementEntry.getValue();
            Element userElement = new Element("user", namespace);
            userElement.setContent((Collection)newUser.cloneContent());
            usersElement.addContent((Content)userElement);
        }
    }

    private void copyEmails(Namespace namespace, Map<String, Element> usernameToGroups, Element userElement, String lowerCaseUsername) {
        String email;
        Element emailElement;
        Element userElementFromMap = usernameToGroups.get(lowerCaseUsername);
        Element emailFromXml = userElementFromMap.getChild("email");
        if (emailFromXml == null && (emailElement = userElement.getChild("email")) != null && StringUtils.isNotBlank((String)(email = emailElement.getText()))) {
            Element newEmailElement = new Element("email", namespace);
            newEmailElement.setText(email);
            userElementFromMap.addContent((Content)newEmailElement);
        }
    }

    private Map<String, Element> mergeGroups(Element root, Namespace namespace) {
        List groups;
        HashMap foundGroupNames = Maps.newHashMap();
        Element groupsChildren = root.getChild("groups", namespace);
        if (groupsChildren != null && (groups = groupsChildren.getChildren("group", namespace)) != null && !groups.isEmpty()) {
            Iterator groupsIterator = groups.iterator();
            while (groupsIterator.hasNext()) {
                boolean isNewUserDefault;
                Element groupElement = (Element)groupsIterator.next();
                Element groupNameElement = groupElement.getChild("groupName");
                String groupName = groupNameElement.getText();
                String lowerCaseGroupName = groupName.toLowerCase();
                if (!foundGroupNames.containsKey(lowerCaseGroupName)) {
                    groupNameElement.setText(lowerCaseGroupName);
                    foundGroupNames.put(lowerCaseGroupName, groupElement);
                    continue;
                }
                Element autoJoinElement = groupElement.getChild("newUserDefault");
                if (autoJoinElement != null && (isNewUserDefault = Boolean.parseBoolean(autoJoinElement.getText()))) {
                    Element existingGroupElement = (Element)foundGroupNames.get(lowerCaseGroupName);
                    Element existingNewUserDefault = existingGroupElement.getChild("newUserDefault");
                    if (existingNewUserDefault != null) {
                        existingNewUserDefault.setText("true");
                    } else {
                        Element newUserDefault = new Element("newUserDefault");
                        newUserDefault.setText("true");
                        existingGroupElement.addContent((Content)newUserDefault);
                    }
                }
                groupsIterator.remove();
            }
        }
        return foundGroupNames;
    }

    private void addGroupsToUser(Element userElement, Element userToGetGroupsFrom, Namespace namespace) {
        Set<String> existingGroupNames = this.getUserGroups(userElement);
        Set<String> newGroupNames = this.getUserGroups(userToGetGroupsFrom);
        existingGroupNames.addAll(newGroupNames);
        Element groupsElement = userElement.getChild("groups");
        if (groupsElement != null) {
            groupsElement.removeChildren("userGroup");
            for (String groupName : existingGroupNames) {
                Element userGroup = new Element("userGroup", namespace);
                userGroup.setText(groupName.toLowerCase());
                groupsElement.addContent((Content)userGroup);
            }
        }
    }

    private Set<String> getUserGroups(Element userElement) {
        List userGroups;
        HashSet groups = Sets.newHashSet();
        Element groupsElement = userElement.getChild("groups");
        if (groupsElement != null && (userGroups = groupsElement.getChildren("userGroup")) != null && !userGroups.isEmpty()) {
            for (Object group : userGroups) {
                Element groupElement = (Element)group;
                groups.add(groupElement.getText().toLowerCase());
            }
        }
        return groups;
    }

    private void mergeAcls(Element root, Namespace namespace) {
        List acls = root.getChildren("acls", namespace);
        if (acls != null && !acls.isEmpty()) {
            for (Object acl : acls) {
                Element aclElement = (Element)acl;
                List aces = aclElement.getChildren("acl", namespace);
                if (aces == null || aces.isEmpty()) continue;
                for (Object ace : aces) {
                    Element aceElement = (Element)ace;
                    List childAces = aceElement.getChildren("aces", namespace);
                    if (childAces == null || childAces.isEmpty()) continue;
                    for (Object childAce : childAces) {
                        HashMap aclMap = Maps.newHashMap();
                        Element childAceElement = (Element)childAce;
                        List aceName = childAceElement.getChildren("ace");
                        if (aceName == null || aceName.isEmpty()) continue;
                        Iterator iterator = aceName.iterator();
                        while (iterator.hasNext()) {
                            Element child = (Element)iterator.next();
                            Element principalElement = child.getChild("principal");
                            boolean isGroup = Boolean.parseBoolean(child.getChild("group").getText());
                            String principal = principalElement.getText();
                            String principalLowerCase = principal.toLowerCase();
                            String finalGroupName = principalLowerCase + " " + isGroup;
                            principalElement.setText(principalLowerCase);
                            if (!aclMap.containsKey(finalGroupName)) {
                                aclMap.put(finalGroupName, child);
                                continue;
                            }
                            Element element = (Element)aclMap.get(finalGroupName);
                            int newMask = Integer.parseInt(child.getChild("mask").getText());
                            Element originalElementMask = element.getChild("mask");
                            int originalMask = Integer.parseInt(originalElementMask.getText());
                            originalElementMask.setText(String.valueOf(newMask |= originalMask));
                            iterator.remove();
                        }
                    }
                }
            }
        }
    }
}

