/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.security.v4;

import java.util.List;
import org.artifactory.security.ArtifactoryPermission;
import org.artifactory.version.converter.XmlConverter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class AnnotatePermissionXmlConverter
implements XmlConverter {
    private static final String ACES = "aces";
    private static final String MASK = "mask";
    private static final String PRINCIPAL = "principal";
    private static final String ACE = "ace";
    private static final String GROUP = "group";

    public void convert(Document doc) {
        Element aclsTag = doc.getRootElement().getChild("acls");
        List acls = aclsTag.getChildren();
        for (Element acl : acls) {
            Element acesTag = acl.getChild(ACES);
            List aces = acesTag.getChildren(ACE);
            Element newAces = new Element(ACES);
            Element aceTemplate = new Element(ACE);
            Element groupEl = new Element(GROUP);
            aceTemplate.addContent((Content)new Element(PRINCIPAL)).addContent((Content)groupEl).addContent((Content)new Element(MASK));
            for (Element ace : aces) {
                Element child = ace.getChild(PRINCIPAL);
                Element newAce = aceTemplate.clone();
                newAce.getChild(PRINCIPAL).setText(ace.getChildText(PRINCIPAL));
                newAce.getChild(GROUP).setText(ace.getChildText(GROUP));
                Element maskEl = ace.getChild(MASK);
                int mask = Integer.parseInt(maskEl.getText());
                if (!child.getText().equals("anonymous") && (mask & (ArtifactoryPermission.MANAGE.getMask() | ArtifactoryPermission.DEPLOY.getMask())) > 0) {
                    mask |= ArtifactoryPermission.ANNOTATE.getMask();
                }
                newAce.getChild(MASK).setText("" + mask);
                newAces.addContent((Content)newAce);
            }
            acl.removeChild(ACES);
            acl.addContent((Content)newAces);
        }
    }
}

