/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.security.v3;

import java.util.List;
import org.artifactory.version.converter.XmlConverter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyRemoteConverter
implements XmlConverter {
    private static final Logger log = LoggerFactory.getLogger(AnyRemoteConverter.class);

    public void convert(Document doc) {
        Element aclsTag = doc.getRootElement().getChild("acls");
        if (this.shouldAddDefaultAnyRemote(aclsTag)) {
            Element acl = new Element("acl");
            Element permissionTarget = new Element("permissionTarget");
            permissionTarget.addContent((Content)this.newElement("name", "Any Remote"));
            permissionTarget.addContent((Content)this.newElement("repoKey", "ANY REMOTE"));
            Element includes = new Element("includes");
            includes.addContent((Content)this.newElement("string", "**"));
            permissionTarget.addContent((Content)includes);
            permissionTarget.addContent((Content)new Element("excludes"));
            acl.addContent((Content)permissionTarget);
            Element aces = new Element("aces");
            Element ace = new Element("ace");
            ace.addContent((Content)this.newElement("principal", "anonymous"));
            ace.addContent((Content)this.newElement("group", "false"));
            ace.addContent((Content)this.newElement("mask", "3"));
            aces.addContent((Content)ace);
            acl.addContent((Content)aces);
            acl.addContent((Content)this.newElement("updatedBy", "_system_"));
            aclsTag.addContent((Content)acl);
        } else {
            log.debug("No need to add default any remote permissions");
        }
    }

    private boolean shouldAddDefaultAnyRemote(Element aclsTag) {
        List acls = aclsTag.getChildren();
        for (Element acl : acls) {
            Element acesTag;
            Element permissionTarget = acl.getChild("permissionTarget");
            String repoKey = permissionTarget.getChildText("repoKey");
            if (!"ANY".equals(repoKey) || (acesTag = acl.getChild("aces")) == null) continue;
            List aces = acesTag.getChildren();
            for (Element ace : aces) {
                if (!"anonymous".equals(ace.getChildText("principal"))) continue;
                return true;
            }
        }
        return false;
    }

    private Element newElement(String name, String value) {
        Element element = new Element(name);
        element.setText(value);
        return element;
    }
}

