/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.security.v2;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.artifactory.repo.InternalRepoPathFactory;
import org.artifactory.repo.RepoPath;
import org.artifactory.security.ArtifactoryPermission;
import org.artifactory.version.converter.XmlConverter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoPathAclConverter
implements XmlConverter {
    private static final Logger log = LoggerFactory.getLogger(RepoPathAclConverter.class);
    private static final String IDENTIFIER = "identifier";
    private static final String ACES = "aces";
    private static final String MASK = "mask";
    private static final String PRINCIPAL = "principal";

    public void convert(Document doc) {
        Element aclsTag = doc.getRootElement().getChild("acls");
        List acls = aclsTag.getChildren();
        for (Element acl : acls) {
            if (acl.getName().contains("RepoPathAcl")) {
                acl.setName("acl");
                this.convertIdentifierToPermissionTarget(acl);
                Element acesTag = acl.getChild(ACES);
                Element aceListTag = acesTag.getChild("list");
                List aces = aceListTag.getChildren("org.artifactory.security.RepoPathAce");
                Element newAces = new Element(ACES);
                Element aceTemplate = new Element("ace");
                Element groupEl = new Element("group");
                groupEl.setText("false");
                aceTemplate.addContent((Content)new Element(PRINCIPAL)).addContent((Content)groupEl).addContent((Content)new Element(MASK));
                for (Element ace : aces) {
                    Element newAce = aceTemplate.clone();
                    newAce.getChild(PRINCIPAL).setText(ace.getChildText(PRINCIPAL));
                    Element maskEl = ace.getChild(MASK);
                    int mask = Integer.parseInt(maskEl.getText());
                    if ((mask & (ArtifactoryPermission.MANAGE.getMask() | ArtifactoryPermission.DEPLOY.getMask())) > 0) {
                        mask |= ArtifactoryPermission.DELETE.getMask();
                    }
                    newAce.getChild(MASK).setText("" + mask);
                    newAces.addContent((Content)newAce);
                }
                acl.removeChild(ACES);
                acl.addContent((Content)newAces);
                continue;
            }
            log.warn("Acl tag " + acl + " under acls is not a RepoPAthAcl!");
        }
    }

    private void convertIdentifierToPermissionTarget(Element acl) {
        String identifier;
        try {
            identifier = URLDecoder.decode(acl.getChildText(IDENTIFIER), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to decode identifier", e);
        }
        RepoPath repoPath = InternalRepoPathFactory.fromId((String)identifier);
        acl.removeChild(IDENTIFIER);
        Element permissionTarget = new Element("permissionTarget");
        Element nameEl = new Element("name");
        if (repoPath.getRepoKey().equalsIgnoreCase("ANY") && repoPath.getPath().equalsIgnoreCase("ANY")) {
            nameEl.setText("Anything");
        } else {
            nameEl.setText(repoPath.getId());
        }
        permissionTarget.addContent((Content)nameEl);
        Element repoKeyEl = new Element("repoKey");
        repoKeyEl.setText(repoPath.getRepoKey());
        permissionTarget.addContent((Content)repoKeyEl);
        Element includesEl = new Element("includes");
        Element includeEl = new Element("string");
        if (repoPath.getPath().equalsIgnoreCase("ANY")) {
            includeEl.setText("**");
        } else {
            includeEl.setText(repoPath.getPath() + "/**");
        }
        includesEl.addContent((Content)includeEl);
        permissionTarget.addContent((Content)includesEl);
        permissionTarget.addContent((Content)new Element("excludes"));
        acl.addContent((Content)permissionTarget);
    }
}

