/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.security.v1;

import java.util.List;
import org.artifactory.version.converter.XmlConverter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPermissionsConverter
implements XmlConverter {
    private static final Logger log = LoggerFactory.getLogger(UserPermissionsConverter.class);

    public void convert(Document doc) {
        Element root = doc.getRootElement();
        Element usersElement = root.getChild("users");
        if (usersElement == null) {
            log.warn("No users found");
            return;
        }
        List users = usersElement.getChildren("org.artifactory.security.SimpleUser");
        block0: for (Element user : users) {
            Element authoritiesElement = user.getChild("authorities");
            if (authoritiesElement == null) {
                log.warn("No authorities found for {}", (Object)user.getChildText("username"));
                continue;
            }
            List authorities = authoritiesElement.getChildren("org.acegisecurity.GrantedAuthorityImpl");
            for (Element authority : authorities) {
                if (!"ADMIN".equals(authority.getChildText("role"))) continue;
                user.addContent((Content)new Element("admin").setText("true"));
                continue block0;
            }
        }
    }
}

