/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.security.v1;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.artifactory.version.converter.XmlConverter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclsConverter
implements XmlConverter {
    private static final Logger log = LoggerFactory.getLogger(AclsConverter.class);

    public void convert(Document doc) {
        Element root = doc.getRootElement();
        root.removeChild("repoPaths");
        Element aclsElement = root.getChild("acls");
        List acls = aclsElement.getChildren();
        if (acls == null) {
            log.warn("No acls detected");
            return;
        }
        root.removeChild("acls");
        Element newAclsElement = new Element("acls");
        root.addContent((Content)newAclsElement);
        Map<Integer, String> objectIdentitiesMap = this.buildObjectIdentitiesMap(acls);
        HashMap<String, Element> newAclsByIdentity = new HashMap<String, Element>();
        for (Element oldAcl : acls) {
            if ("org.acegisecurity.acl.basic.SimpleAclEntry".equals(oldAcl.getName())) {
                Element objectIdentity = oldAcl.getChild("aclObjectIdentity");
                if (this.hasIdentity(objectIdentity)) {
                    Element newAcl = new Element("org.artifactory.security.RepoPathAcl");
                    String newIdentity = this.getNewIdentity(objectIdentity);
                    newAcl.addContent((Content)new Element("identifier").setText(newIdentity));
                    Element aces = new Element("aces");
                    newAcl.addContent((Content)aces);
                    aces.addContent((Content)new Element("list"));
                    this.addAceToAcl(oldAcl, newAcl);
                    newAclsByIdentity.put(newIdentity, newAcl);
                    newAclsElement.addContent((Content)newAcl);
                    continue;
                }
                String reference = objectIdentity.getAttributeValue("reference");
                Pattern pattern = Pattern.compile(".*org.acegisecurity.acl.basic.SimpleAclEntry\\[(.*)\\].*");
                Matcher matcher = pattern.matcher(reference);
                if (matcher.matches()) {
                    String indexStr = matcher.group(1);
                    int identityIndex = Integer.parseInt(indexStr);
                    String identity = objectIdentitiesMap.get(identityIndex);
                    Element newAcl = (Element)newAclsByIdentity.get(identity);
                    this.addAceToAcl(oldAcl, newAcl);
                    continue;
                }
                log.warn("Couldn't match identity reference {}", (Object)reference);
                continue;
            }
            log.warn("Acl tag " + oldAcl + " under acls is not a SimpleAclEntry!");
        }
    }

    private void addAceToAcl(Element oldAcl, Element newAcl) {
        Element acesListElement = newAcl.getChild("aces").getChild("list");
        String user = oldAcl.getChildText("recipient");
        String mask = oldAcl.getChildText("mask");
        if ("___INHERITENCE_MARKER_ONLY___".equals(user)) {
            user = "anonymous";
            mask = "1";
        }
        Element ace = new Element("org.artifactory.security.RepoPathAce");
        ace.addContent((Content)new Element("principal").setText(user));
        ace.addContent((Content)new Element("mask").setText(mask));
        acesListElement.addContent((Content)ace);
    }

    private boolean hasIdentity(Element objectIdentity) {
        return objectIdentity.getChild("repoKey") != null;
    }

    private Map<Integer, String> buildObjectIdentitiesMap(List<Element> acls) {
        HashMap<Integer, String> identities = new HashMap<Integer, String>();
        for (int i = 0; i < acls.size(); ++i) {
            Element acl = acls.get(i);
            Element objectIdentity = acl.getChild("aclObjectIdentity");
            if (!this.hasIdentity(objectIdentity)) continue;
            String identity = this.getNewIdentity(objectIdentity);
            identities.put(i + 1, identity);
        }
        return identities;
    }

    private String getNewIdentity(Element objectIdentity) {
        String repoKey = objectIdentity.getChildText("repoKey");
        String path = objectIdentity.getChildText("path");
        String identity = repoKey + "%3a" + path;
        return identity;
    }
}

