/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.security;

import java.util.ArrayList;
import java.util.Arrays;
import org.artifactory.update.security.v1.AclsConverter;
import org.artifactory.update.security.v1.UserPermissionsConverter;
import org.artifactory.update.security.v2.RepoPathAclConverter;
import org.artifactory.update.security.v2.SimpleUserConverter;
import org.artifactory.update.security.v3.AclRepoKeysConverter;
import org.artifactory.update.security.v3.AnyRemoteConverter;
import org.artifactory.update.security.v4.AnnotatePermissionXmlConverter;
import org.artifactory.update.security.v6.LdapGroupSettingXmlConverter;
import org.artifactory.update.security.v6.LowercaseUsernameXmlConverter;
import org.artifactory.update.security.v8.Md5TemplateHashPasswordConverter;
import org.artifactory.version.ArtifactoryVersion;
import org.artifactory.version.ArtifactoryVersionProvider;
import org.artifactory.version.VersionWrapper;
import org.artifactory.version.XmlConverterUtils;
import org.artifactory.version.converter.XmlConverter;

public enum SecurityVersion implements VersionWrapper
{
    unsupported(ArtifactoryVersionProvider.v122rc0.get(), new XmlConverter[0]){

        @Override
        public String convert(String in) {
            throw new IllegalStateException("Reading security data from backup of Artifactory version older than 1.2.5-rc6 is not supported!");
        }
    }
    ,
    v1(ArtifactoryVersionProvider.v125.get(), new UserPermissionsConverter(), new AclsConverter()),
    v2(ArtifactoryVersionProvider.v130beta1.get(), new SimpleUserConverter(), new RepoPathAclConverter()),
    v3(ArtifactoryVersionProvider.v130beta3.get(), new AnyRemoteConverter(), new AclRepoKeysConverter()),
    v4(ArtifactoryVersionProvider.v210.get(), new AnnotatePermissionXmlConverter()),
    v5(ArtifactoryVersionProvider.v211.get(), new XmlConverter[0]),
    v6(ArtifactoryVersionProvider.v213.get(), new LdapGroupSettingXmlConverter(), new LowercaseUsernameXmlConverter()),
    v7(ArtifactoryVersionProvider.v220.get(), new XmlConverter[0]),
    v8(ArtifactoryVersionProvider.v265.get(), new Md5TemplateHashPasswordConverter()),
    v9(ArtifactoryVersionProvider.v560m001.get(), new XmlConverter[0]),
    v10(ArtifactoryVersionProvider.v660m001.get(), new XmlConverter[0]);

    private static final String VERSION_ATT = "version=\"";
    private ArtifactoryVersion version;
    private final XmlConverter[] xmlConverters;

    private SecurityVersion(ArtifactoryVersion version, XmlConverter ... xmlConverters) {
        this.version = version;
        this.xmlConverters = xmlConverters;
    }

    public boolean isLast() {
        return this == SecurityVersion.values()[SecurityVersion.values().length - 1];
    }

    public XmlConverter[] getXmlConverters() {
        return this.xmlConverters;
    }

    public String convert(String securityXmlAsString) {
        SecurityVersion[] versions;
        ArrayList<XmlConverter> converters = new ArrayList<XmlConverter>();
        for (SecurityVersion version : versions = SecurityVersion.values()) {
            if (version.ordinal() < this.ordinal() || version.getXmlConverters() == null) continue;
            converters.addAll(Arrays.asList(version.getXmlConverters()));
        }
        return XmlConverterUtils.convert(converters, (String)securityXmlAsString);
    }

    public static SecurityVersion last() {
        SecurityVersion[] versions;
        for (SecurityVersion version : versions = SecurityVersion.values()) {
            if (!version.isLast()) continue;
            return version;
        }
        throw new IllegalStateException("Should have a current version!");
    }

    public ArtifactoryVersion getVersion() {
        return this.version;
    }

    public static SecurityVersion findVersion(String securityData) {
        int versionIdx = securityData.indexOf(VERSION_ATT);
        if (versionIdx != -1) {
            int versionStartIndex = versionIdx + VERSION_ATT.length();
            String cutVersion = securityData.substring(versionStartIndex);
            String isolatedVersion = cutVersion.substring(0, cutVersion.indexOf(34));
            return SecurityVersion.valueOf(isolatedVersion);
        }
        int groupsIdx = securityData.indexOf("<groups>");
        int userIdx = securityData.indexOf("<user>");
        int simpleUserIdx = securityData.indexOf("SimpleUser>");
        int aclIdIdx = securityData.indexOf("<aclObjectIdentity");
        if (userIdx != -1 || groupsIdx != -1) {
            return v3;
        }
        if (aclIdIdx != -1) {
            return v1;
        }
        if (simpleUserIdx != -1) {
            return v2;
        }
        return unsupported;
    }
}

