/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.security;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.artifactory.factory.InfoFactoryHolder;
import org.artifactory.security.SecurityInfo;
import org.artifactory.update.security.SecurityVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityInfoReader {
    private static final Logger log = LoggerFactory.getLogger(SecurityInfoReader.class);

    public SecurityInfo read(File securityFile) {
        SecurityInfo securityInfo;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(securityFile);
            securityInfo = this.read(fis);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException("File not found: " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return securityInfo;
    }

    public SecurityInfo read(InputStream is) {
        String xmlContent;
        try {
            xmlContent = IOUtils.toString((InputStream)is, (String)"utf-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read file content: " + e.getMessage(), e);
        }
        return this.read(xmlContent);
    }

    public SecurityInfo read(String xmlContent) {
        SecurityVersion xmlSecurityVersion = SecurityVersion.findVersion(xmlContent);
        if (!xmlSecurityVersion.isLast()) {
            log.info("Converting security.xml version from '{}' to '{}'", (Object)xmlSecurityVersion.toString(), (Object)SecurityVersion.last());
            xmlContent = xmlSecurityVersion.convert(xmlContent);
        }
        XStream xStream = InfoFactoryHolder.get().getSecurityXStream();
        SecurityInfo securityInfo = (SecurityInfo)xStream.fromXML(xmlContent);
        return securityInfo;
    }
}

