/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.md.v230;

import org.artifactory.update.md.MetadataConverter;
import org.artifactory.update.md.MetadataType;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class BaseRepoPathClassConverter
implements MetadataConverter {
    public void convert(Document doc) {
        Element rootElement = doc.getRootElement();
        Element repoPath = rootElement.getChild("repoPath");
        if (repoPath != null && repoPath.getAttribute("class") != null) {
            repoPath.removeAttribute("class");
        }
    }

    public static class WatchersRepoPathClassConverter
    extends BaseRepoPathClassConverter {
        @Override
        public String getNewMetadataName() {
            return "watchers";
        }

        @Override
        public MetadataType getSupportedMetadataType() {
            return MetadataType.watch;
        }
    }

    public static class FolderRepoPathClassConverter
    extends BaseRepoPathClassConverter {
        @Override
        public String getNewMetadataName() {
            return "artifactory-folder";
        }

        @Override
        public MetadataType getSupportedMetadataType() {
            return MetadataType.folder;
        }
    }

    public static class FileRepoPathClassConverter
    extends BaseRepoPathClassConverter {
        @Override
        public String getNewMetadataName() {
            return "artifactory-file";
        }

        @Override
        public MetadataType getSupportedMetadataType() {
            return MetadataType.file;
        }
    }
}

