/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.md.v130beta6;

import org.artifactory.checksum.ChecksumType;
import org.artifactory.update.md.MetadataConverter;
import org.artifactory.update.md.MetadataType;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumsConverter
implements MetadataConverter {
    private static final Logger log = LoggerFactory.getLogger(ChecksumsConverter.class);
    public static final String ARTIFACTORY_FILE = "artifactory-file";

    public void convert(Document doc) {
        Element root = doc.getRootElement();
        Element extension = root.getChild("extension");
        extension.setName("additionalInfo");
        Element sha1Node = extension.getChild("sha1");
        String sha1 = null;
        if (sha1Node != null) {
            sha1 = sha1Node.getValue();
            extension.removeContent((Content)sha1Node);
        } else {
            log.debug("SHA1 checksum not found, setting it to {}", (Object)sha1);
        }
        Element md5Node = extension.getChild("md5");
        String md5 = null;
        if (md5Node != null) {
            md5 = md5Node.getValue();
            extension.removeContent((Content)md5Node);
        } else {
            log.debug("MD5 checksum not found, setting it to {}", (Object)md5);
        }
        Element checksumsInfo = new Element("checksumsInfo");
        extension.addContent((Content)checksumsInfo);
        Element checksums = new Element("checksums");
        checksumsInfo.addContent((Content)checksums);
        this.addChecksum(checksums, ChecksumType.sha1, sha1);
        this.addChecksum(checksums, ChecksumType.md5, md5);
    }

    private void addChecksum(Element checksums, ChecksumType type, String checksum) {
        Element checksumElement = new Element("checksum");
        checksumElement.addContent((Content)this.createTextElement("type", type.name()));
        checksumElement.addContent((Content)this.createTextElement("original", "NO_ORIG"));
        checksumElement.addContent((Content)this.createTextElement("actual", checksum));
        checksums.addContent((Content)checksumElement);
    }

    private Element createTextElement(String elementName, String value) {
        Element element = new Element(elementName);
        element.setText(value);
        return element;
    }

    @Override
    public String getNewMetadataName() {
        return ARTIFACTORY_FILE;
    }

    @Override
    public MetadataType getSupportedMetadataType() {
        return MetadataType.file;
    }
}

