/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.md.v130beta3;

import java.util.List;
import org.artifactory.mime.MimeType;
import org.artifactory.mime.NamingUtils;
import org.artifactory.repo.RepoPath;
import org.artifactory.update.md.MetadataConverter;
import org.artifactory.update.md.MetadataConverterUtils;
import org.artifactory.update.md.MetadataType;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class ArtifactoryFileConverter
implements MetadataConverter {
    public static final String ARTIFACTORY_FILE = "artifactory.file";

    @Override
    public String getNewMetadataName() {
        return "artifactory-file";
    }

    @Override
    public MetadataType getSupportedMetadataType() {
        return MetadataType.file;
    }

    public void convert(Document doc) {
        Element rootElement = doc.getRootElement();
        if (rootElement.getName().equals(this.getNewMetadataName())) {
            return;
        }
        rootElement.setName(this.getNewMetadataName());
        RepoPath repoPath = MetadataConverterUtils.extractRepoPath(rootElement);
        List<Element> toMove = MetadataConverterUtils.extractExtensionFields(rootElement);
        MetadataConverterUtils.addNewContent(rootElement, repoPath, toMove);
        MimeType ct = NamingUtils.getMimeType((String)repoPath.getName());
        rootElement.removeChild("mimeType");
        rootElement.addContent((Content)new Element("mimeType").setText(ct.getType()));
    }
}

