/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.md.v125rc0;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.artifactory.common.MutableStatusHolder;
import org.artifactory.fs.MetadataEntryInfo;
import org.artifactory.sapi.fs.MetadataReader;
import org.artifactory.update.md.MetadataConverter;
import org.artifactory.update.md.MetadataConverterUtils;
import org.artifactory.update.md.current.PassThroughMetadataReaderImpl;
import org.artifactory.update.md.v125rc0.MdFileConverter;
import org.artifactory.update.md.v125rc0.MdFolderConverter;
import org.artifactory.update.md.v125rc0.MdStatsConverter;
import org.artifactory.update.md.v130beta6.ChecksumsConverter;
import org.artifactory.update.md.v130beta6.FolderAdditionalInfoNameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataReader125
implements MetadataReader {
    private static final Logger log = LoggerFactory.getLogger(MetadataReader125.class);
    private final MetadataConverter folderConverter = new MdFolderConverter();
    private final MetadataConverter fileConverter = new MdFileConverter();
    private final MetadataConverter statsConverter = new MdStatsConverter();

    public List<MetadataEntryInfo> getMetadataEntries(File file, MutableStatusHolder status) {
        if (!file.isFile()) {
            status.error("Expecting a file but got a directory: " + file.getAbsolutePath(), log);
            return Collections.emptyList();
        }
        ArrayList<MetadataEntryInfo> result = new ArrayList<MetadataEntryInfo>();
        try {
            String xmlContent = FileUtils.readFileToString((File)file, (String)"utf-8");
            if (xmlContent.contains("<file>")) {
                String fileXmlContent = MetadataConverterUtils.convertString(this.fileConverter, xmlContent);
                ChecksumsConverter checksumsConverter = new ChecksumsConverter();
                fileXmlContent = MetadataConverterUtils.convertString(checksumsConverter, fileXmlContent);
                String fileMetadataName = checksumsConverter.getNewMetadataName();
                result.add(PassThroughMetadataReaderImpl.createME(fileMetadataName, fileXmlContent));
                result.add(this.convert(xmlContent, this.statsConverter));
            } else if (xmlContent.contains("<folder>")) {
                xmlContent = MetadataConverterUtils.convertString(this.folderConverter, xmlContent);
                FolderAdditionalInfoNameConverter folderConverter = new FolderAdditionalInfoNameConverter();
                xmlContent = MetadataConverterUtils.convertString(folderConverter, xmlContent);
                String fileMetadataName = folderConverter.getNewMetadataName();
                result.add(PassThroughMetadataReaderImpl.createME(fileMetadataName, xmlContent));
            } else {
                status.error("Failed to import xml metadata from '" + file.getAbsolutePath() + "' since it does not contain any known XML tag <file> <folder>.", log);
            }
        }
        catch (IOException e) {
            status.error("Failed to import xml metadata from '" + file.getAbsolutePath() + "'.", (Throwable)e, log);
        }
        return result;
    }

    private MetadataEntryInfo convert(String xmlContent, MetadataConverter converter) {
        xmlContent = MetadataConverterUtils.convertString(converter, xmlContent);
        MetadataEntryInfo metadataEntry = PassThroughMetadataReaderImpl.createME(converter.getNewMetadataName(), xmlContent);
        return metadataEntry;
    }

    public MetadataEntryInfo convertMetadataEntry(MetadataEntryInfo metadataEntryInfo) {
        throw new IllegalStateException("Cannot convert the root metadata reader " + this);
    }
}

