/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.md.v125rc0;

import java.util.List;
import org.artifactory.repo.InternalRepoPathFactory;
import org.artifactory.repo.RepoPath;
import org.artifactory.update.md.MetadataConverter;
import org.artifactory.update.md.MetadataConverterUtils;
import org.artifactory.update.md.MetadataType;
import org.jdom2.Document;
import org.jdom2.Element;

public class MdFolderConverter
implements MetadataConverter {
    static final String ARTIFACTORY_NAME = "artifactoryName";

    @Override
    public String getNewMetadataName() {
        return "artifactory-folder";
    }

    @Override
    public MetadataType getSupportedMetadataType() {
        return MetadataType.folder;
    }

    public void convert(Document doc) {
        Element rootElement = doc.getRootElement();
        rootElement.setName(this.getNewMetadataName());
        RepoPath repoPath = MetadataConverterUtils.extractRepoPath(rootElement);
        if (rootElement.getChild(ARTIFACTORY_NAME) != null) {
            String name = rootElement.getChildText(ARTIFACTORY_NAME);
            repoPath = InternalRepoPathFactory.create((RepoPath)repoPath, (String)name);
        }
        List<Element> toMove = MetadataConverterUtils.extractExtensionFields(rootElement);
        MetadataConverterUtils.addNewContent(rootElement, repoPath, toMove);
        rootElement.removeChild(ARTIFACTORY_NAME);
    }
}

