/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.md.current;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.artifactory.common.MutableStatusHolder;
import org.artifactory.factory.InfoFactoryHolder;
import org.artifactory.fs.MetadataEntryInfo;
import org.artifactory.sapi.fs.MetadataReader;
import org.artifactory.util.Files;
import org.jfrog.client.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassThroughMetadataReaderImpl
implements MetadataReader {
    private static final Logger log = LoggerFactory.getLogger(PassThroughMetadataReaderImpl.class);

    public List<MetadataEntryInfo> getMetadataEntries(File file, MutableStatusHolder status) {
        if (!file.isDirectory()) {
            status.error("Expecting a directory but got file: " + file.getAbsolutePath(), log);
            return Collections.emptyList();
        }
        String[] metadataFileNames = file.list((FilenameFilter)new SuffixFileFilter(".xml"));
        if (metadataFileNames == null) {
            status.error("Cannot read list of metadata files from " + file.getAbsolutePath() + ": " + Files.readFailReason((File)file), log);
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)metadataFileNames.length);
        for (String metadataFileName : metadataFileNames) {
            File metadataFile = new File(file, metadataFileName);
            String extension = PathUtils.getExtension((String)metadataFileName);
            if (!this.verify(status, metadataFileName, metadataFile, extension)) continue;
            status.debug("Importing metadata from '" + metadataFile.getPath() + "'.", log);
            try {
                String metadataName = PathUtils.stripExtension((String)metadataFileName);
                String xmlContent = FileUtils.readFileToString((File)metadataFile, (String)"utf-8");
                MetadataEntryInfo metadataEntry = this.createMetadataEntry(metadataName, xmlContent);
                result.add(metadataEntry);
            }
            catch (Exception e) {
                status.error("Failed to import xml metadata from '" + metadataFile.getAbsolutePath() + "'.", (Throwable)e, log);
            }
        }
        return result;
    }

    private boolean verify(MutableStatusHolder status, String metadataFileName, File metadataFile, String extension) {
        if (metadataFile.exists() && metadataFile.isDirectory()) {
            status.warn("Skipping xml metadata import from '" + metadataFile.getAbsolutePath() + "'. Expected a file but encountered a folder.", log);
            return false;
        }
        if (extension.length() + 1 >= metadataFileName.length()) {
            status.warn("Skipping xml metadata import from '" + metadataFile.getAbsolutePath() + "'. The file does not have a name.", log);
            return false;
        }
        return true;
    }

    protected MetadataEntryInfo createMetadataEntry(String metadataName, String xmlContent) {
        return PassThroughMetadataReaderImpl.createME(metadataName, xmlContent);
    }

    public MetadataEntryInfo convertMetadataEntry(MetadataEntryInfo metadataEntryInfo) {
        return metadataEntryInfo;
    }

    public static MetadataEntryInfo createME(String metadataName, String xmlContent) {
        return InfoFactoryHolder.get().createMetadataEntry(metadataName, xmlContent);
    }
}

